/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class ExecuteEnchantment
extends BaseEnchantment {
    public ExecuteEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 3;
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        LivingEntity livingTarget;
        float damageBonus;
        if (!attacker.m_9236_().f_46443_ && target instanceof LivingEntity && (damageBonus = this.calculateDamageBonus(livingTarget = (LivingEntity)target, level)) > 0.0f) {
            float baseDamage = this.getBaseDamage(attacker);
            float extraDamage = baseDamage * damageBonus;
            livingTarget.m_6469_(attacker.m_269291_().m_269333_(attacker), extraDamage);
        }
    }

    private float calculateDamageBonus(LivingEntity target, int level) {
        float currentHealth = target.m_21223_();
        float maxHealth = target.m_21233_();
        float healthRatio = currentHealth / maxHealth;
        float maxBonus = 0.15f + 0.1f * (float)(level - 1);
        float damageBonus = (1.0f - healthRatio) * maxBonus;
        return Math.max(0.0f, damageBonus);
    }

    private float getBaseDamage(LivingEntity attacker) {
        return (float)attacker.m_21133_(Attributes.f_22281_);
    }

    public static float getExecuteDamageMultiplier(LivingEntity target, int level) {
        float currentHealth = target.m_21223_();
        float maxHealth = target.m_21233_();
        float healthRatio = currentHealth / maxHealth;
        float maxBonus = 0.15f + 0.1f * (float)(level - 1);
        float damageBonus = (1.0f - healthRatio) * maxBonus;
        return 1.0f + Math.max(0.0f, damageBonus);
    }
}

