/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ExplosionEnchantment
extends BaseEnchantment {
    public ExplosionEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 5;
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        if (!attacker.m_9236_().f_46443_ && target instanceof LivingEntity) {
            float triggerChance = 0.15f + (float)level * 0.05f;
            if (attacker.m_217043_().m_188501_() < triggerChance) {
                this.triggerSafeExplosion(attacker.m_9236_(), target.m_20183_(), level, attacker);
            }
        }
    }

    private void triggerSafeExplosion(Level level, BlockPos center, int levelInt, LivingEntity source) {
        Explosion explosion = new Explosion(level, (Entity)source, (double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), 3.0f, false, Explosion.BlockInteraction.KEEP);
        AABB explosionArea = new AABB((double)center.m_123341_() - 1.5, (double)center.m_123342_() - 1.5, (double)center.m_123343_() - 1.5, (double)center.m_123341_() + 1.5, (double)center.m_123342_() + 1.5, (double)center.m_123343_() + 1.5);
        List entities = level.m_45933_((Entity)source, explosionArea);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == source) continue;
            livingEntity.m_6469_(source.m_269291_().m_269425_(), 2.0f);
        }
        level.m_255391_((Entity)source, (double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), 1.0f, false, Level.ExplosionInteraction.NONE);
    }
}

