/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;

public class GuardianStrikeEnchantment
extends BaseEnchantment {
    private static final Map<UUID, GuardianStrikeData> guardianStrikeMap = new HashMap<UUID, GuardianStrikeData>();
    private static final int EFFECT_DURATION = 60;

    public GuardianStrikeEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 4;
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        if (!attacker.m_9236_().f_46443_ && target instanceof LivingEntity) {
            this.activateGuardianStrike(attacker, level);
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12346_, attacker.m_5720_(), 0.8f, 1.0f);
        }
    }

    private void activateGuardianStrike(LivingEntity attacker, int level) {
        UUID attackerId = attacker.m_20148_();
        long expireTime = attacker.m_9236_().m_46467_() + 60L;
        float damageReduction = this.getDamageReduction(level);
        guardianStrikeMap.put(attackerId, new GuardianStrikeData(damageReduction, expireTime));
        if (attacker.m_9236_().f_46443_) {
            this.spawnActivationParticles(attacker);
        }
    }

    private float getDamageReduction(int level) {
        return switch (level) {
            case 1 -> 0.15f;
            case 2 -> 0.25f;
            case 3 -> 0.35f;
            case 4 -> 0.45f;
            default -> 0.0f;
        };
    }

    private void spawnActivationParticles(LivingEntity attacker) {
        for (int i = 0; i < 8; ++i) {
            double x = attacker.m_20185_() + (attacker.m_217043_().m_188500_() - 0.5) * (double)attacker.m_20205_();
            double y = attacker.m_20186_() + attacker.m_217043_().m_188500_() * (double)attacker.m_20206_();
            double z = attacker.m_20189_() + (attacker.m_217043_().m_188500_() - 0.5) * (double)attacker.m_20205_();
            attacker.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 0.0, 0.1, 0.0);
        }
    }

    public static float applyDamageReduction(LivingEntity entity, float originalDamage) {
        UUID entityId = entity.m_20148_();
        GuardianStrikeData data = guardianStrikeMap.get(entityId);
        if (data != null && entity.m_9236_().m_46467_() <= data.expireTime) {
            float reducedDamage = originalDamage * (1.0f - data.damageReduction);
            if (entity.m_9236_().f_46443_) {
                GuardianStrikeEnchantment.spawnReductionParticles(entity);
            }
            return reducedDamage;
        }
        return originalDamage;
    }

    private static void spawnReductionParticles(LivingEntity entity) {
        for (int i = 0; i < 4; ++i) {
            double x = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_();
            double y = entity.m_20186_() + entity.m_217043_().m_188500_() * (double)entity.m_20206_();
            double z = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_();
            entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, 0.0, 0.05, 0.0);
        }
    }

    public static void cleanupExpiredData(Level level) {
        long currentTime = level.m_46467_();
        guardianStrikeMap.entrySet().removeIf(entry -> ((GuardianStrikeData)entry.getValue()).expireTime <= currentTime);
    }

    public static boolean hasGuardianStrikeActive(LivingEntity entity) {
        UUID entityId = entity.m_20148_();
        GuardianStrikeData data = guardianStrikeMap.get(entityId);
        return data != null && entity.m_9236_().m_46467_() <= data.expireTime;
    }

    public static float getCurrentDamageReduction(LivingEntity entity) {
        UUID entityId = entity.m_20148_();
        GuardianStrikeData data = guardianStrikeMap.get(entityId);
        if (data != null && entity.m_9236_().m_46467_() <= data.expireTime) {
            return data.damageReduction;
        }
        return 0.0f;
    }

    private static class GuardianStrikeData {
        public final float damageReduction;
        public final long expireTime;

        public GuardianStrikeData(float damageReduction, long expireTime) {
            this.damageReduction = damageReduction;
            this.expireTime = expireTime;
        }
    }
}

