/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import com.bmt.de.enchantment.VoidAssaultEnchantment;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class PainCycleEnchantment
extends BaseEnchantment {
    private static final Map<UUID, Integer> attackCountMap = new HashMap<UUID, Integer>();

    public PainCycleEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment other) {
        return super.m_5975_(other) && !(other instanceof VoidAssaultEnchantment);
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        if (!attacker.m_9236_().f_46443_ && target instanceof LivingEntity) {
            UUID attackerId = attacker.m_20148_();
            int currentCount = attackCountMap.getOrDefault(attackerId, 0) + 1;
            attackCountMap.put(attackerId, currentCount);
            if (currentCount >= 5) {
                this.triggerPainCycle(attacker, (LivingEntity)target, level);
                attackCountMap.put(attackerId, 0);
            } else {
                this.consumeHealth(attacker, level);
            }
        }
    }

    private void consumeHealth(LivingEntity attacker, int level) {
        float maxHealth = attacker.m_21233_();
        float healthCost = maxHealth * 0.1f;
        if (attacker.m_21223_() > healthCost) {
            attacker.m_6469_(attacker.m_269291_().m_269425_(), healthCost);
        }
    }

    private void triggerPainCycle(LivingEntity attacker, LivingEntity target, int level) {
        float baseDamage = this.getBaseDamage(attacker);
        float multiplierDamage = baseDamage * (float)(level + 1);
        float maxHealth = attacker.m_21233_();
        float healthCost = maxHealth * 0.1f;
        if (attacker.m_21223_() > healthCost) {
            attacker.m_6469_(attacker.m_269291_().m_269425_(), healthCost);
            target.m_6469_(attacker.m_269291_().m_269333_(attacker), multiplierDamage);
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12323_, attacker.m_5720_(), 1.0f, 0.5f);
        }
    }

    private float getBaseDamage(LivingEntity attacker) {
        return (float)attacker.m_21133_(Attributes.f_22281_);
    }

    public static void cleanupOldData() {
        attackCountMap.entrySet().removeIf(entry -> false);
    }
}

