/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.EnchantmentRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dream_enchantment")
class ProspectorEventHandler {
    ProspectorEventHandler() {
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            Enchantment prospectorEnchantment = (Enchantment)EnchantmentRegistry.PROSPECTOR.get();
            int prospectorLevel = EnchantmentHelper.m_44836_((Enchantment)prospectorEnchantment, (LivingEntity)attacker);
            if (prospectorLevel > 0) {
                float dropChance = 0.02f * (float)prospectorLevel;
                if (attacker.m_217043_().m_188501_() < dropChance) {
                    ProspectorEventHandler.dropRandomOre(attacker.m_9236_(), target.m_20183_());
                }
            }
        }
    }

    private static void dropRandomOre(Level level, BlockPos pos) {
        List<OreDrop> ores = ProspectorEventHandler.getDefaultOres();
        int totalWeight = ores.stream().mapToInt(ore -> ore.weight).sum();
        if (totalWeight <= 0) {
            return;
        }
        RandomSource random = level.f_46441_;
        int randomValue = random.m_188503_(totalWeight);
        int currentWeight = 0;
        ItemStack oreStack = null;
        for (OreDrop ore2 : ores) {
            if (randomValue >= (currentWeight += ore2.weight)) continue;
            oreStack = new ItemStack((ItemLike)ore2.item);
            break;
        }
        if (oreStack == null) {
            oreStack = new ItemStack((ItemLike)Items.f_151052_);
        }
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, oreStack);
        level.m_7967_((Entity)itemEntity);
        level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 1.0f);
        System.out.println("\u63a2\u77ff\u8005\u9644\u9b54\u6389\u843d: " + oreStack.m_41720_().m_5524_());
    }

    private static List<OreDrop> getDefaultOres() {
        return List.of(new OreDrop(Items.f_151052_, 35), new OreDrop(Items.f_42416_, 25), new OreDrop(Items.f_42534_, 15), new OreDrop(Items.f_42417_, 10), new OreDrop(Items.f_42616_, 10), new OreDrop(Items.f_42415_, 5));
    }

    private static class OreDrop {
        public final Item item;
        public final int weight;

        public OreDrop(Item item, int weight) {
            this.item = item;
            this.weight = weight;
        }
    }
}

