/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;

public class SoulSynergyEnchantment
extends BaseEnchantment {
    private static final Map<UUID, Map<UUID, Long>> markedTargets = new HashMap<UUID, Map<UUID, Long>>();
    private static final int MARK_DURATION = 600;
    private static final int MAX_MARKS = 3;

    public SoulSynergyEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 1;
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        if (!attacker.m_9236_().f_46443_ && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            this.markTarget(attacker, livingTarget);
            this.shareDamageToOtherMarks(attacker, livingTarget);
        }
    }

    private void markTarget(LivingEntity attacker, LivingEntity target) {
        UUID attackerId = attacker.m_20148_();
        UUID targetId = target.m_20148_();
        Map attackerMarks = markedTargets.computeIfAbsent(attackerId, k -> new HashMap());
        this.cleanupExpiredMarks(attackerMarks, attacker.m_9236_().m_46467_());
        if (attackerMarks.containsKey(targetId)) {
            long expireTime = attacker.m_9236_().m_46467_() + 600L;
            attackerMarks.put(targetId, expireTime);
            return;
        }
        if (attackerMarks.size() >= 3) {
            this.removeOldestMark(attackerMarks);
        }
        long expireTime = attacker.m_9236_().m_46467_() + 600L;
        attackerMarks.put(targetId, expireTime);
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11887_, attacker.m_5720_(), 0.5f, 1.5f);
        System.out.println("\u6807\u8bb0\u76ee\u6807: " + String.valueOf(targetId) + ", \u5f53\u524d\u6807\u8bb0\u6570\u91cf: " + attackerMarks.size());
    }

    private void shareDamageToOtherMarks(LivingEntity attacker, LivingEntity primaryTarget) {
        UUID attackerId = attacker.m_20148_();
        Map<UUID, Long> attackerMarks = markedTargets.get(attackerId);
        if (attackerMarks == null || attackerMarks.size() <= 1) {
            return;
        }
        ArrayList<LivingEntity> otherMarkedTargets = new ArrayList<LivingEntity>();
        for (UUID targetId : attackerMarks.keySet()) {
            LivingEntity livingEntity;
            Entity entity;
            if (targetId.equals(primaryTarget.m_20148_()) || !((entity = this.findEntityByUUID(attacker.m_9236_(), targetId)) instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_6084_()) continue;
            otherMarkedTargets.add(livingEntity);
        }
        if (otherMarkedTargets.isEmpty()) {
            return;
        }
        float baseDamage = this.getBaseDamage(attacker);
        float sharedDamage = baseDamage / 3.0f;
        for (LivingEntity otherTarget : otherMarkedTargets) {
            otherTarget.m_6469_(attacker.m_269291_().m_269333_(attacker), sharedDamage);
            attacker.m_9236_().m_6263_(null, otherTarget.m_20185_(), otherTarget.m_20186_(), otherTarget.m_20189_(), SoundEvents.f_12404_, otherTarget.m_5720_(), 0.3f, 1.0f);
            this.spawnDamageParticles(otherTarget);
        }
    }

    private Entity findEntityByUUID(Level level, UUID uuid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_8791_(uuid);
        }
        return null;
    }

    private void spawnDamageParticles(LivingEntity target) {
        if (target.m_9236_().f_46443_) {
            for (int i = 0; i < 5; ++i) {
                double x = target.m_20185_() + (target.m_217043_().m_188500_() - 0.5) * (double)target.m_20205_();
                double y = target.m_20186_() + target.m_217043_().m_188500_() * (double)target.m_20206_();
                double z = target.m_20189_() + (target.m_217043_().m_188500_() - 0.5) * (double)target.m_20205_();
                target.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void cleanupExpiredMarks(Map<UUID, Long> marks, long currentTime) {
        marks.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
    }

    private void removeOldestMark(Map<UUID, Long> marks) {
        if (marks.isEmpty()) {
            return;
        }
        UUID oldestMark = null;
        long oldestTime = Long.MAX_VALUE;
        for (Map.Entry<UUID, Long> entry : marks.entrySet()) {
            if (entry.getValue() >= oldestTime) continue;
            oldestTime = entry.getValue();
            oldestMark = entry.getKey();
        }
        if (oldestMark != null) {
            marks.remove(oldestMark);
            System.out.println("\u79fb\u9664\u6700\u65e7\u6807\u8bb0: " + String.valueOf(oldestMark));
        }
    }

    private float getBaseDamage(LivingEntity attacker) {
        return (float)attacker.m_21133_(Attributes.f_22281_);
    }

    public static int getMarkCount(LivingEntity attacker) {
        Map<UUID, Long> marks = markedTargets.get(attacker.m_20148_());
        return marks != null ? marks.size() : 0;
    }

    public static List<UUID> getMarkedTargets(LivingEntity attacker) {
        Map<UUID, Long> marks = markedTargets.get(attacker.m_20148_());
        return marks != null ? new ArrayList<UUID>(marks.keySet()) : new ArrayList();
    }

    public static void debugMarkInfo(LivingEntity attacker) {
        Map<UUID, Long> marks = markedTargets.get(attacker.m_20148_());
        if (marks != null) {
            System.out.println("\u73a9\u5bb6 " + String.valueOf(attacker.m_20148_()) + " \u7684\u6807\u8bb0\u4fe1\u606f:");
            for (Map.Entry<UUID, Long> entry : marks.entrySet()) {
                System.out.println("  \u76ee\u6807: " + String.valueOf(entry.getKey()) + ", \u8fc7\u671f\u65f6\u95f4: " + String.valueOf(entry.getValue()));
            }
        } else {
            System.out.println("\u73a9\u5bb6 " + String.valueOf(attacker.m_20148_()) + " \u6ca1\u6709\u6807\u8bb0");
        }
    }
}

