/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.enchantment;

import com.bmt.de.enchantment.BaseEnchantment;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;

public class VoidEchoEnchantment
extends BaseEnchantment {
    private static final Map<String, DelayedDamageInfo> delayedDamageMap = new HashMap<String, DelayedDamageInfo>();

    public VoidEchoEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 4;
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        if (!attacker.m_9236_().f_46443_ && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            float originalDamage = this.getBaseDamage(attacker);
            float delayedDamage = originalDamage * (0.1f * (float)level);
            String damageKey = livingTarget.m_20148_().toString() + "_" + attacker.m_9236_().m_46467_();
            delayedDamageMap.put(damageKey, new DelayedDamageInfo(delayedDamage, attacker, attacker.m_9236_().m_46467_() + 40L));
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
        }
    }

    public static void processDelayedDamage(Level level) {
        long currentTime = level.m_46467_();
        delayedDamageMap.entrySet().removeIf(entry -> {
            DelayedDamageInfo info = (DelayedDamageInfo)entry.getValue();
            if (currentTime >= info.triggerTime) {
                LivingEntity livingTarget;
                UUID targetId;
                Entity target;
                String[] keyParts = ((String)entry.getKey()).split("_");
                if (keyParts.length >= 1 && (target = VoidEchoEnchantment.findEntityByUUID(level, targetId = UUID.fromString(keyParts[0]))) instanceof LivingEntity && (livingTarget = (LivingEntity)target).m_6084_()) {
                    livingTarget.m_6469_(info.attacker.m_269291_().m_269425_(), info.damage);
                }
                return true;
            }
            return false;
        });
    }

    private static Entity findEntityByUUID(Level level, UUID uuid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_8791_(uuid);
        }
        return null;
    }

    private float getBaseDamage(LivingEntity attacker) {
        return (float)attacker.m_21133_(Attributes.f_22281_);
    }

    private static class DelayedDamageInfo {
        public final float damage;
        public final LivingEntity attacker;
        public final long triggerTime;

        public DelayedDamageInfo(float damage, LivingEntity attacker, long triggerTime) {
            this.damage = damage;
            this.attacker = attacker;
            this.triggerTime = triggerTime;
        }
    }
}

