/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.event;

import com.bmt.de.EnchantmentRegistry;
import com.bmt.de.enchantment.AmbushEnchantment;
import com.bmt.de.enchantment.ExecuteEnchantment;
import com.bmt.de.enchantment.GuardianStrikeEnchantment;
import com.bmt.de.enchantment.SoulResonanceEnchantment;
import com.bmt.de.enchantment.VigorEnchantment;
import com.bmt.de.enchantment.VoidAssaultEnchantment;
import com.bmt.de.enchantment.VoidEchoEnchantment;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dream_enchantment")
public class DamageEventHandler {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        float originalDamage;
        LivingEntity target;
        float reducedDamage;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Enchantment executeEnchantment;
            int executeLevel;
            Enchantment soulResonanceEnchantment;
            int soulResonanceLevel;
            float vigorBonus;
            Enchantment vigorEnchantment;
            int vigorLevel;
            Enchantment ambushEnchantment;
            int ambushLevel;
            float originalAmount;
            Player player = (Player)entity;
            if (player.m_9236_().f_46443_) {
                return;
            }
            float modifiedAmount = originalAmount = event.getAmount();
            LivingEntity target2 = event.getEntity();
            Enchantment voidAssaultEnchantment = (Enchantment)EnchantmentRegistry.VOID_ASSAULT.get();
            int voidAssaultLevel = EnchantmentHelper.m_44836_((Enchantment)voidAssaultEnchantment, (LivingEntity)player);
            if (voidAssaultLevel > 0 && player.m_217043_().m_188501_() < 0.15f) {
                float multiplier = VoidAssaultEnchantment.getVoidAssaultMultiplier(voidAssaultLevel);
                modifiedAmount = originalAmount * multiplier;
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
            }
            if ((ambushLevel = EnchantmentHelper.m_44836_((Enchantment)(ambushEnchantment = (Enchantment)EnchantmentRegistry.AMBUSH.get()), (LivingEntity)player)) > 0 && AmbushEnchantment.isPlayerSneaking(player)) {
                float multiplier = AmbushEnchantment.getSneakDamageMultiplier(ambushLevel);
                modifiedAmount *= multiplier;
            }
            if ((vigorLevel = EnchantmentHelper.m_44836_((Enchantment)(vigorEnchantment = (Enchantment)EnchantmentRegistry.VIGOR.get()), (LivingEntity)player)) > 0 && (vigorBonus = VigorEnchantment.getVigorDamageBonus(player, vigorLevel)) > 0.0f) {
                modifiedAmount *= 1.0f + vigorBonus;
                VigorEnchantment.recordPlayerJump(player);
            }
            if ((soulResonanceLevel = EnchantmentHelper.m_44836_((Enchantment)(soulResonanceEnchantment = (Enchantment)EnchantmentRegistry.SOUL_RESONANCE.get()), (LivingEntity)player)) > 0) {
                int playerExperienceLevel = player.f_36078_;
                float soulResonanceMultiplier = SoulResonanceEnchantment.getSoulResonanceDamageBonus(player, soulResonanceLevel);
                modifiedAmount *= 1.0f + soulResonanceMultiplier;
            }
            if ((executeLevel = EnchantmentHelper.m_44836_((Enchantment)(executeEnchantment = (Enchantment)EnchantmentRegistry.EXECUTE.get()), (LivingEntity)player)) > 0) {
                float executeMultiplier = ExecuteEnchantment.getExecuteDamageMultiplier(target2, executeLevel);
                modifiedAmount *= executeMultiplier;
            }
            if (modifiedAmount != originalAmount) {
                event.setAmount(modifiedAmount);
            }
        }
        if ((reducedDamage = GuardianStrikeEnchantment.applyDamageReduction(target = event.getEntity(), originalDamage = event.getAmount())) != originalDamage) {
            event.setAmount(reducedDamage);
            if (!target.m_9236_().f_46443_) {
                target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12346_, target.m_5720_(), 0.5f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            VigorEnchantment.recordPlayerJump(player);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            VoidEchoEnchantment.processDelayedDamage((Level)event.getServer().m_129783_());
            GuardianStrikeEnchantment.cleanupExpiredData((Level)event.getServer().m_129783_());
        }
    }
}

