/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.de.event;

import com.bmt.de.EnchantmentRegistry;
import com.bmt.de.enchantment.AmbushEnchantment;
import com.bmt.de.enchantment.BusyBeeEnchantment;
import com.bmt.de.enchantment.ChargeEnchantment;
import com.bmt.de.enchantment.SoulResonanceEnchantment;
import com.bmt.de.enchantment.VigorEnchantment;
import com.bmt.de.enchantment.VoidEchoEnchantment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="dream_enchantment")
public class EnchantmentEventHandler {
    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        if (player != null) {
            int soulResonanceLevel;
            RegistryObject<Enchantment> soulResonanceEnchantment;
            int vigorLevel;
            RegistryObject<Enchantment> vigorEnchantment;
            int ambushLevel;
            float totalBonus = 0.0f;
            RegistryObject<Enchantment> ambushEnchantment = EnchantmentRegistry.getEnchantment("ambush");
            if (ambushEnchantment != null && (ambushLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ambushEnchantment.get()), (LivingEntity)player)) > 0) {
                totalBonus += AmbushEnchantment.getAmbushDamageBonus(player, ambushLevel);
            }
            if ((vigorEnchantment = EnchantmentRegistry.getEnchantment("vigor")) != null && (vigorLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)vigorEnchantment.get()), (LivingEntity)player)) > 0) {
                totalBonus += VigorEnchantment.getVigorDamageBonus(player, vigorLevel);
            }
            if ((soulResonanceEnchantment = EnchantmentRegistry.getEnchantment("soul_resonance")) != null && (soulResonanceLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)soulResonanceEnchantment.get()), (LivingEntity)player)) > 0) {
                totalBonus += SoulResonanceEnchantment.getSoulResonanceDamageBonus(player, soulResonanceLevel);
            }
            if (totalBonus > 0.0f) {
                event.setDamageModifier(event.getDamageModifier() + totalBonus);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            VoidEchoEnchantment.processDelayedDamage((Level)event.getServer().m_129783_());
            BusyBeeEnchantment.cleanupAllDeadBees((Level)event.getServer().m_129783_());
            ChargeEnchantment.cleanupExpiredCooldowns((Level)event.getServer().m_129783_());
        }
    }

    @SubscribeEvent
    public static void onPlayerJump(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = event.getEntity();
            VigorEnchantment.recordPlayerJump(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = event.getEntity();
            BusyBeeEnchantment.removeAllBees((LivingEntity)player);
        }
    }
}

