/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import team.creative.solonion.api.FoodPlayerData;
import team.creative.solonion.api.OnionFoodContainer;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.client.gui.elements.UIInventoryButton;
import team.creative.solonion.client.gui.screen.FoodBookScreen;
import team.creative.solonion.client.gui.screen.FoodContainerScreen;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.item.SOLOnionItems;

public class SOLOnionClient {
    public static final KeyMapping.Category SOL_CATEGORY = new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"solonion", (String)"category"));
    public static final KeyMapping OPEN_FOOD_BOOK = new KeyMapping("key.solonion.open_food_book", InputConstants.UNKNOWN.getValue(), SOL_CATEGORY);

    public static void load(IEventBus bus) {
        bus.addListener(SOLOnionClient::setupClient);
        bus.addListener(SOLOnionClient::registerMenu);
        bus.addListener(SOLOnionClient::registerKeybinds);
        NeoForge.EVENT_BUS.addListener(SOLOnionClient::handleKeypress);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, SOLOnionClient::onItemTooltip);
        NeoForge.EVENT_BUS.addListener(SOLOnionClient::addButton);
    }

    public static void setupClient(FMLClientSetupEvent event) {
    }

    public static void registerMenu(RegisterMenuScreensEvent event) {
        event.register(SOLOnionItems.FOOD_CONTAINER.get(), FoodContainerScreen::new);
    }

    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.registerCategory(SOL_CATEGORY);
        event.register(OPEN_FOOD_BOOK);
    }

    public static void handleKeypress(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (OPEN_FOOD_BOOK != null && OPEN_FOOD_BOOK.isDown()) {
            FoodBookScreen.open((Player)player);
        }
    }

    public static void onItemTooltip(ItemTooltipEvent event) {
        FoodProperties foodproperties;
        if (!SOLOnion.CONFIG.isFoodTooltipEnabled) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof OnionFoodContainer) {
            OnionFoodContainer c = (OnionFoodContainer)item;
            stack = c.getActualFood(player, stack);
        }
        if ((foodproperties = (FoodProperties)stack.get(DataComponents.FOOD)) == null) {
            return;
        }
        FoodPlayerData food = SOLOnionAPI.getFoodCapability(player);
        SOLOnionClient.addTooltip(food.simulateEat((LivingEntity)player, stack), food.getLastEaten((LivingEntity)player, stack), stack, event.getToolTip(), player);
    }

    public static void addButton(ScreenEvent.Init.Post evt) {
        Screen screen = evt.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen s = (InventoryScreen)screen;
            if (SOLOnion.CONFIG.showButtonInInventory) {
                evt.addListener((GuiEventListener)new UIInventoryButton((AbstractContainerScreen)s));
            }
        }
    }

    public static void addTooltip(double diversity, int lastEaten, ItemStack stack, List<Component> tooltip, Player player) {
        boolean isAllowed = SOLOnion.CONFIG.isAllowed(player.level(), stack);
        if (!isAllowed) {
            if (SOLOnion.CONFIG.showDisabledTooltip) {
                tooltip.add((Component)Component.translatable((String)"gui.solonion.tooltip.disabled").withStyle(style -> style.applyFormat(ChatFormatting.DARK_GRAY)));
            }
            return;
        }
        ChatFormatting color = ChatFormatting.GRAY;
        if (diversity < 0.0) {
            color = ChatFormatting.RED;
        } else if (diversity > 0.0) {
            color = ChatFormatting.GREEN;
        }
        MutableComponent text = Component.translatable((String)"gui.solonion.tooltip.diversity").append(": " + String.format("%.2f", SOLOnion.CONFIG.getDiversity((LivingEntity)player, stack))).withStyle(ChatFormatting.GRAY);
        if (SOLOnion.CONFIG.showDiversityChangeInTooltip) {
            text = text.append(" (").append((Component)Component.literal((String)String.format("%.2f", diversity)).withStyle(color)).append(")");
        }
        tooltip.add((Component)text);
        if (lastEaten != -1) {
            String last_eaten_path = "tooltip.last_eaten";
            if (lastEaten == 1) {
                last_eaten_path = "tooltip.last_eaten_singular";
            }
            tooltip.add((Component)Component.translatable((String)("gui.solonion." + last_eaten_path), (Object[])new Object[]{lastEaten}).withStyle(ChatFormatting.GRAY));
        }
    }
}

