/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import team.creative.solonion.api.BenefitPlayerData;
import team.creative.solonion.common.benefit.BenefitStack;
import team.creative.solonion.common.benefit.BenefitType;

public class BenefitPlayerDataImpl
implements BenefitPlayerData {
    private HashMap<BenefitType, Object> applied = new HashMap();

    @Override
    public void updateStack(Player player, BenefitStack benefits) {
        for (BenefitType type : BenefitType.types()) {
            Object app = this.applied.get(type);
            Object stack = benefits.get(type);
            if (app == null) {
                if (stack == null) continue;
                app = type.createApplied();
                this.applied.put(type, app);
            }
            if (!type.apply(player, app, stack)) continue;
            this.applied.remove(type);
        }
    }

    public void serialize(ValueOutput output) {
        for (Map.Entry<BenefitType, Object> entry : this.applied.entrySet()) {
            ValueOutput child = output.child(entry.getKey().getId());
            entry.getKey().saveApplied(entry.getValue(), child);
            if (!child.isEmpty()) continue;
            output.discard(entry.getKey().getId());
        }
    }

    public void deserialize(ValueInput input) {
        for (Map.Entry<BenefitType, Object> entry : this.applied.entrySet()) {
            entry.getKey().clearApplied(entry.getValue());
        }
        if (input == null) {
            return;
        }
        for (BenefitType type : BenefitType.types()) {
            Optional child = input.child(type.getId());
            if (child.isPresent()) {
                Object app = this.applied.get(type);
                if (app == null) {
                    app = type.createApplied();
                    this.applied.put(type, app);
                }
                type.loadApplied(app, (ValueInput)child.get());
                continue;
            }
            this.applied.remove(type);
        }
    }

    @Override
    public <T> T getApplied(BenefitType<?, ?, T> type) {
        return (T)this.applied.get(type);
    }
}

