/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.solonion.common.benefit.Benefit;
import team.creative.solonion.common.benefit.BenefitAttribute;
import team.creative.solonion.common.benefit.BenefitMobEffect;

public abstract class BenefitType<T extends Benefit, L, A> {
    private static final NamedHandlerRegistry<BenefitType> REGISTRY = new NamedHandlerRegistry(null);
    private static final HashMap<Class, String> IDS = new HashMap();
    private static final HashMap<Class, BenefitType> TYPE_MAP = new HashMap();
    public final Function<CompoundTag, T> factory;

    public static <R extends Benefit> void register(String id, Class<R> clazz, BenefitType<R, ?, ?> type) {
        REGISTRY.register(id, type);
        IDS.put(clazz, id);
        TYPE_MAP.put(clazz, type);
    }

    public static TextMapBuilder<BenefitType> typeMap() {
        return new TextMapBuilder().addEntrySet(REGISTRY.entrySet(), x -> Component.translatable((String)("config.solonion." + (String)x.getKey())));
    }

    public static Benefit load(CompoundTag nbt) {
        BenefitType type = (BenefitType)REGISTRY.get(nbt.getStringOr("type", ""));
        if (type == null) {
            throw new IllegalArgumentException("Could not find type " + String.valueOf(nbt));
        }
        return (Benefit)type.factory.apply(nbt);
    }

    public static BenefitType getType(Benefit benefit) {
        return TYPE_MAP.get(benefit.getClass());
    }

    public static BenefitType getType(Class<? extends Benefit> clazz) {
        return TYPE_MAP.get(clazz);
    }

    public static String getId(Benefit benefit) {
        return IDS.get(benefit.getClass());
    }

    public static String getId(Class<? extends Benefit> clazz) {
        return IDS.get(clazz);
    }

    public static Iterable<BenefitType> types() {
        return REGISTRY.values();
    }

    public BenefitType(Function<CompoundTag, T> factory) {
        this.factory = factory;
    }

    public String getId() {
        return REGISTRY.getId((Object)this);
    }

    public abstract Registry registry();

    public abstract void createControls(GuiParent var1, IGuiConfigParent var2);

    public abstract void loadValue(T var1, GuiParent var2, IGuiConfigParent var3);

    public abstract T saveValue(ResourceLocation var1, double var2, GuiParent var4, IGuiConfigParent var5);

    public abstract L createStack();

    public abstract void addToStack(T var1, L var2);

    public abstract boolean isEmpty(L var1);

    public abstract A createApplied();

    public abstract boolean apply(Player var1, A var2, @Nullable L var3);

    public abstract void clearApplied(A var1);

    public abstract void loadApplied(A var1, ValueInput var2);

    public abstract void saveApplied(A var1, ValueOutput var2);

    static {
        BenefitType.register("eff", BenefitMobEffect.class, new BenefitMobEffect.BenefitTypeMobEffect(BenefitMobEffect::new));
        BenefitType.register("att", BenefitAttribute.class, new BenefitAttribute.BenefitTypeAttribute(BenefitAttribute::new));
    }
}

