/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.food;

import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import team.creative.creativecore.common.util.type.itr.ArrayOffsetIterator;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;
import team.creative.solonion.api.FoodPlayerData;
import team.creative.solonion.common.SOLOnion;

public final class FoodPlayerDataImpl
implements FoodPlayerData {
    private ItemStack[] lastEaten;
    private int startIndex;
    private double diversityCache;

    private static double calculateDiversity(Iterable<ItemStack> stacks, LivingEntity entity) {
        Object2DoubleArrayMap types = new Object2DoubleArrayMap();
        int i = 0;
        for (ItemStack stack : stacks) {
            double d = FoodPlayerDataImpl.calculateDiversity(entity, stack, i);
            types.computeDouble((Object)stack.getItem(), (x, y) -> {
                if (y == null) {
                    return d;
                }
                return Math.max(y, d);
            });
            ++i;
        }
        double d = 0.0;
        for (Object2DoubleMap.Entry entry : types.object2DoubleEntrySet()) {
            d += entry.getDoubleValue();
        }
        return d;
    }

    public static TupleList<ItemStack, Double> calculateDiversityIndividualy(Iterable<ItemStack> stacks, LivingEntity entity) {
        TupleList results = new TupleList();
        HashMap<Item, Tuple> types = new HashMap<Item, Tuple>();
        int i = 0;
        for (ItemStack stack : stacks) {
            double d = FoodPlayerDataImpl.calculateDiversity(entity, stack, i);
            Tuple existing = (Tuple)types.get(stack.getItem());
            boolean overwrite = false;
            if (existing != null) {
                if ((Double)existing.value >= d) {
                    d = 0.0;
                } else {
                    existing.value = 0.0;
                    overwrite = true;
                }
            } else {
                overwrite = true;
            }
            Tuple tuple = new Tuple((Object)stack, (Object)d);
            results.add((Object)tuple);
            if (overwrite) {
                types.put(stack.getItem(), tuple);
            }
            ++i;
        }
        return results;
    }

    public static double calculateDiversity(LivingEntity entity, ItemStack stack, int index) {
        return SOLOnion.CONFIG.getDiversity(entity, stack) * (SOLOnion.CONFIG.trackedFoodDiversityDecay ? 1.0 - (double)index / ((double)SOLOnion.CONFIG.trackCount + 1.0) : 1.0);
    }

    public FoodPlayerDataImpl() {
        this.lastEaten = new ItemStack[SOLOnion.CONFIG.trackCount];
        this.startIndex = this.lastEaten.length - 1;
        this.diversityCache = -1.0;
    }

    private void updateDiversity(LivingEntity entity) {
        this.diversityCache = FoodPlayerDataImpl.calculateDiversity(this, entity);
    }

    public void serialize(ValueOutput output) {
        ValueOutput.TypedOutputList list = output.list("eaten", ItemStack.CODEC);
        for (ItemStack stack : this) {
            list.add((Object)stack);
        }
    }

    public void deserialize(ValueInput input) {
        ValueInput.TypedInputList list = input.listOrEmpty("eaten", ItemStack.CODEC);
        int index = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.lastEaten[index] = (ItemStack)iterator.next();
            if (index >= this.lastEaten.length) break;
            ++index;
        }
        for (int i = index; i < this.lastEaten.length; ++i) {
            this.lastEaten[i] = null;
        }
        this.startIndex = 0;
        this.diversityCache = -1.0;
    }

    @Override
    public void eat(LivingEntity entity, ItemStack stack) {
        if (!SOLOnion.CONFIG.isAllowed(entity.level(), stack) || !SOLOnion.CONFIG.shouldExcludedCount) {
            return;
        }
        --this.startIndex;
        if (this.startIndex < 0) {
            this.startIndex = this.lastEaten.length - 1;
        }
        this.lastEaten[this.startIndex] = stack.copy();
        this.updateDiversity(entity);
    }

    @Override
    public double simulateEat(LivingEntity entity, ItemStack stack) {
        if (!SOLOnion.CONFIG.isAllowed(entity.level(), stack) || !SOLOnion.CONFIG.shouldExcludedCount) {
            return 0.0;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(SOLOnion.CONFIG.trackCount);
        for (ItemStack toAdd : this) {
            stacks.add(toAdd);
        }
        if (stacks.size() == SOLOnion.CONFIG.trackCount) {
            stacks.remove(stacks.size() - 1);
        }
        stacks.add(0, stack);
        return FoodPlayerDataImpl.calculateDiversity(stacks, entity) - this.foodDiversity(entity);
    }

    @Override
    public double foodDiversity(LivingEntity entity) {
        if (this.diversityCache == -1.0) {
            this.updateDiversity(entity);
        }
        return this.diversityCache;
    }

    @Override
    public int trackCount() {
        int count = 0;
        for (int i = 0; i < this.lastEaten.length; ++i) {
            if (this.lastEaten[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getLastEaten(LivingEntity entity, ItemStack food) {
        if (food.get(DataComponents.FOOD) == null) {
            return -1;
        }
        double d = SOLOnion.CONFIG.getDiversity(entity, food);
        int i = 0;
        for (ItemStack stack : this) {
            if (stack.getItem() == food.getItem() && SOLOnion.CONFIG.getDiversity(entity, stack) == d) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean hasEaten(LivingEntity entity, ItemStack food) {
        if (food.get(DataComponents.FOOD) == null) {
            return false;
        }
        double d = SOLOnion.CONFIG.getDiversity(entity, food);
        for (ItemStack stack : this) {
            if (stack.getItem() != food.getItem() || SOLOnion.CONFIG.getDiversity(entity, stack) != d) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearAll() {
        Arrays.fill(this.lastEaten, null);
        this.startIndex = this.lastEaten.length - 1;
        this.diversityCache = 0.0;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new FilterIterator(new ArrayOffsetIterator(this.startIndex, (Object[])this.lastEaten).iterator(), x -> x != null);
    }

    @Override
    public void configChanged() {
        if (this.lastEaten.length != SOLOnion.CONFIG.trackCount) {
            ItemStack[] newLastEaten = new ItemStack[SOLOnion.CONFIG.trackCount];
            int i = 0;
            Iterator<ItemStack> iterator = this.iterator();
            while (iterator.hasNext()) {
                ItemStack stack;
                newLastEaten[i] = stack = iterator.next();
                if (++i < newLastEaten.length) continue;
                break;
            }
            this.lastEaten = newLastEaten;
            this.startIndex = 0;
        }
        this.diversityCache = -1.0;
    }
}

