/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.api;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import team.creative.solonion.api.BenefitPlayerData;
import team.creative.solonion.api.FoodPlayerData;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.benefit.BenefitPlayerDataImpl;
import team.creative.solonion.common.food.FoodPlayerDataImpl;

public final class SOLOnionAPI {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"solonion");
    public static final ResourceLocation FOOD = ResourceLocation.tryBuild((String)"solonion", (String)"foodlist");
    public static final ResourceLocation BENEFIT = ResourceLocation.tryBuild((String)"solonion", (String)"benefit");
    public static final ResourceLocation FOODCONTAINER = ResourceLocation.tryBuild((String)"solonion", (String)"food_container");
    public static final Supplier<AttachmentType<FoodPlayerDataImpl>> FOOD_DATA = ATTACHMENT_TYPES.register(FOOD.getPath(), () -> AttachmentType.serializable(() -> new FoodPlayerDataImpl()).build());
    public static final Supplier<AttachmentType<BenefitPlayerDataImpl>> BENEFIT_DATA = ATTACHMENT_TYPES.register(BENEFIT.getPath(), () -> AttachmentType.serializable(() -> new BenefitPlayerDataImpl()).build());

    public static FoodPlayerData getFoodCapability(Player player) {
        if (player.hasData(FOOD_DATA)) {
            return (FoodPlayerData)player.getData(FOOD_DATA);
        }
        FoodPlayerDataImpl food = new FoodPlayerDataImpl();
        player.setData(FOOD_DATA, (Object)food);
        return food;
    }

    public static BenefitPlayerData getBenefitCapability(Player player) {
        if (player.hasData(BENEFIT_DATA)) {
            return (BenefitPlayerData)player.getData(BENEFIT_DATA);
        }
        BenefitPlayerDataImpl benefit = new BenefitPlayerDataImpl();
        player.setData(BENEFIT_DATA, (Object)benefit);
        return benefit;
    }

    public static void syncFoodList(Player player) {
        SOLOnion.EVENT.syncFoodList(player);
    }

    private SOLOnionAPI() {
    }
}

