/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client.gui.screen;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.solonion.api.FoodPlayerData;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.client.gui.BenefitsPage;
import team.creative.solonion.client.gui.DiversityPage;
import team.creative.solonion.client.gui.FoodListPage;
import team.creative.solonion.client.gui.Page;
import team.creative.solonion.client.gui.PageFlipButton;
import team.creative.solonion.client.gui.elements.UIElement;
import team.creative.solonion.client.gui.elements.UIImage;
import team.creative.solonion.client.gui.elements.UILabel;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.benefit.BenefitThreshold;

public final class FoodBookScreen
extends Screen
implements PageFlipButton.Pageable {
    private static final ResourceLocation texture = ResourceLocation.tryBuild((String)"solonion", (String)"textures/gui/food_book.png");
    private static final UIImage.Image bookImage = new UIImage.Image(texture, new Rectangle(0, 0, 186, 192));
    public static final UIImage.Image carrotImage = new UIImage.Image(texture, new Rectangle(0, 240, 16, 16));
    public static final Color fullBlack = Color.BLACK;
    public static final Color lessBlack = new Color(0, 0, 0, 128);
    public static final Color leastBlack = new Color(0, 0, 0, 64);
    public static final Color activeGreen = new Color(29, 104, 29, 255);
    public static final Color inactiveRed = new Color(104, 29, 29, 255);
    private final List<UIElement> elements = new ArrayList<UIElement>();
    private UIImage background;
    private UILabel pageNumberLabel;
    private PageFlipButton nextPageButton;
    private PageFlipButton prevPageButton;
    private Player player;
    private FoodPlayerData foodData;
    private final List<Page> pages = new ArrayList<Page>();
    private int currentPageNumber = 0;

    public static void open(Player player) {
        Minecraft.getInstance().setScreen((Screen)new FoodBookScreen(player));
    }

    public FoodBookScreen(Player player) {
        super((Component)Component.literal((String)""));
        this.player = player;
    }

    public void init() {
        super.init();
        this.foodData = SOLOnionAPI.getFoodCapability(this.player);
        this.background = new UIImage(bookImage);
        this.background.setCenterX(this.width / 2);
        this.background.setCenterY(this.height / 2);
        this.elements.clear();
        this.pageNumberLabel = new UILabel("1");
        this.pageNumberLabel.setCenterX(this.background.getCenterX());
        this.pageNumberLabel.setMinY(this.background.getMinY() + 156);
        this.elements.add(this.pageNumberLabel);
        this.initPages();
        int pageFlipButtonSpacing = 50;
        this.prevPageButton = (PageFlipButton)this.addRenderableWidget((GuiEventListener)new PageFlipButton(this.background.getCenterX() - pageFlipButtonSpacing / 2 - 23, this.background.getMinY() + 152, PageFlipButton.Direction.BACKWARD, this));
        this.nextPageButton = (PageFlipButton)this.addRenderableWidget((GuiEventListener)new PageFlipButton(this.background.getCenterX() + pageFlipButtonSpacing / 2, this.background.getMinY() + 152, PageFlipButton.Direction.FORWARD, this));
        this.updateButtonVisibility();
    }

    private void initPages() {
        this.pages.clear();
        double foodDiversity = this.foodData.foodDiversity((LivingEntity)this.player);
        int foodEaten = this.foodData.trackCount();
        this.pages.add(new DiversityPage(foodDiversity, foodEaten, this.background.frame));
        this.addPages("food_queue_label", Lists.newArrayList((Iterable)this.foodData), this.player);
        ArrayList<BenefitThreshold> active = new ArrayList<BenefitThreshold>();
        ArrayList<BenefitThreshold> inactive = new ArrayList<BenefitThreshold>();
        for (BenefitThreshold threshold : SOLOnion.CONFIG.benefits) {
            if (threshold.threshold <= foodDiversity) {
                active.add(threshold);
                continue;
            }
            inactive.add(threshold);
        }
        this.addPages("active_benefits_header", active, activeGreen);
        if (SOLOnion.CONFIG.shouldShowInactiveBenefits) {
            this.addPages("inactive_benefits_header", inactive, inactiveRed);
        }
        active = new ArrayList();
        inactive = new ArrayList();
        for (BenefitThreshold threshold : SOLOnion.CONFIG.detriments) {
            if (threshold.threshold > foodDiversity) {
                active.add(threshold);
                continue;
            }
            inactive.add(threshold);
        }
        this.addPages("active_detriments_header", active, inactiveRed);
        if (SOLOnion.CONFIG.shouldShowInactiveDetriments) {
            this.addPages("inactive_detriments_header", inactive, activeGreen);
        }
    }

    private void addPages(String headerLocalizationPath, List<BenefitThreshold> benefitInfoList, Color activeColor) {
        String header = LanguageUtils.translate((String)("gui.solonion.food_book." + headerLocalizationPath));
        this.pages.addAll(BenefitsPage.pages(this.background.frame, header, benefitInfoList, activeColor));
    }

    private void addPages(String headerLocalizationPath, List<ItemStack> stacks, Player player) {
        String header = LanguageUtils.translate((String)("gui.solonion.food_book." + headerLocalizationPath), (Object[])new Object[]{stacks.size()});
        this.pages.addAll(FoodListPage.pages(this.background.frame, header, stacks, player));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        UIElement.render(graphics, this.background, mouseX, mouseY);
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (!this.pages.isEmpty()) {
            UIElement.render(graphics, this.elements, mouseX, mouseY);
            UIElement.render(graphics, this.pages.get(this.currentPageNumber), mouseX, mouseY);
        }
    }

    @Override
    public void switchToPage(int pageNumber) {
        if (!this.isWithinRange(pageNumber)) {
            return;
        }
        this.currentPageNumber = pageNumber;
        this.updateButtonVisibility();
        this.pageNumberLabel.text = "" + (this.currentPageNumber + 1);
    }

    @Override
    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    @Override
    public boolean isWithinRange(int pageNumber) {
        return pageNumber >= 0 && pageNumber < this.pages.size();
    }

    private void updateButtonVisibility() {
        this.prevPageButton.updateState();
        this.nextPageButton.updateState();
    }
}

