/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client.gui.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import team.creative.solonion.common.item.foodcontainer.FoodContainer;

public class FoodContainerScreen
extends AbstractContainerScreen<FoodContainer> {
    public FoodContainerScreen(FoodContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.drawBackground(graphics, ResourceLocation.tryBuild((String)"solonion", (String)"textures/gui/inventory.png"));
        ResourceHandler h = (ResourceHandler)((FoodContainer)this.menu).containerItem.getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)((FoodContainer)this.menu).containerItem));
        if (h != null) {
            int slotsPerRow = h.size();
            if (h.size() > 9) {
                slotsPerRow = h.size() / 2;
            }
            int xStart = (178 - slotsPerRow * 18) / 2;
            int yStart = 35;
            if (h.size() > 9) {
                yStart = 29;
            }
            for (int i = 0; i < h.size(); ++i) {
                int row = i / slotsPerRow;
                int col = i % slotsPerRow;
                int xPos = xStart - 1 + col * 18;
                int yPos = yStart - 1 + row * 18;
                this.drawSlot(graphics, xPos, yPos);
            }
        }
    }

    protected void drawBackground(GuiGraphics graphics, ResourceLocation gui) {
        int relX = (this.width - this.getXSize()) / 2;
        int relY = (this.height - this.getYSize()) / 2;
        graphics.blit(RenderPipelines.GUI_TEXTURED, gui, relX, relY, 0.0f, 0.0f, this.getXSize(), this.getYSize(), 256, 256);
    }

    protected void drawSlot(GuiGraphics graphics, int x, int y, ResourceLocation texture, int size) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getGuiLeft() + x, this.getGuiTop() + y, 0.0f, 0.0f, size, size, size, size);
    }

    protected void drawSlot(GuiGraphics graphics, int x, int y) {
        this.drawSlot(graphics, x, y, ResourceLocation.tryBuild((String)"solonion", (String)"textures/gui/slot.png"), 18);
    }
}

