/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.ICreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.type.list.SortingList;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.benefit.BenefitAttribute;
import team.creative.solonion.common.benefit.BenefitMobEffect;
import team.creative.solonion.common.benefit.BenefitThreshold;
import team.creative.solonion.common.food.FoodProperty;

public final class SOLOnionConfig
implements ICreativeConfig {
    @CreativeConfig
    public SortingList foodItems = new SortingList(false);
    @CreativeConfig
    @CreativeConfig.IntRange(min=1, max=1000, slider=true)
    public int trackCount = 32;
    @CreativeConfig
    public boolean resetOnDeath = true;
    @CreativeConfig
    public boolean limitProgressionToSurvival = false;
    @CreativeConfig
    @CreativeConfig.IntRange(min=0, max=1000, slider=true)
    public int minFoodsToActivate = 0;
    @CreativeConfig
    public List<BenefitThreshold> benefits = Arrays.asList(new BenefitThreshold(3.0, new BenefitAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, 2.0)), new BenefitThreshold(5.0, new BenefitMobEffect((Holder<MobEffect>)MobEffects.STRENGTH, 0.0)), new BenefitThreshold(7.0, new BenefitMobEffect((Holder<MobEffect>)MobEffects.REGENERATION, 0.0)), new BenefitThreshold(10.0, new BenefitMobEffect((Holder<MobEffect>)MobEffects.SPEED, 0.0)), new BenefitThreshold(13.0, new BenefitAttribute((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, 2.0)), new BenefitThreshold(18.0, new BenefitMobEffect((Holder<MobEffect>)MobEffects.STRENGTH, 1.0)), new BenefitThreshold(25.0, new BenefitAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, 2.0)), new BenefitThreshold(31.0, new BenefitAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, 2.0)));
    @CreativeConfig
    public List<BenefitThreshold> detriments = Arrays.asList(new BenefitThreshold[0]);
    @CreativeConfig
    public boolean shouldExcludedCount = true;
    @CreativeConfig
    public double complexityStandardNutrition = 5.0;
    @CreativeConfig
    public double complexityStandardSaturation = 6.0;
    @CreativeConfig
    public double complexityBenefitEffectModifier = 0.2;
    @CreativeConfig
    public double complexityNeutralEffectModifier = 0.0;
    @CreativeConfig
    public double complexityHarmEffectModifier = -0.2;
    @CreativeConfig
    public boolean trackedFoodDiversityDecay = true;
    @CreativeConfig
    public List<FoodProperty> foodDiversity = Arrays.asList(new FoodProperty((CreativeIngredient)new CreativeIngredientItem(Items.GOLDEN_CARROT), 2.0), new FoodProperty((CreativeIngredient)new CreativeIngredientItem(Items.GOLDEN_APPLE), 2.0), new FoodProperty((CreativeIngredient)new CreativeIngredientItem(Items.ENCHANTED_GOLDEN_APPLE), 5.0));
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean isFoodTooltipEnabled = true;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean showDiversityChangeInTooltip = true;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean showDisabledTooltip = true;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean shouldShowInactiveBenefits = true;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean shouldShowInactiveDetriments = true;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean showButtonInInventory = true;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public int buttonInventoryX = 130;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public int buttonInventoryY = 62;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public int buttonInventoryWidth = 24;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public int buttonInventoryHeight = 16;

    public void configured(Side side) {
        Collections.sort(this.benefits);
        Collections.sort(this.detriments);
        Collections.reverse(this.detriments);
        if (side.isClient()) {
            return;
        }
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PlayerList players = ServerLifecycleHooks.getCurrentServer().getPlayerList();
            for (Player player : players.getPlayers()) {
                SOLOnionAPI.getFoodCapability(player).configChanged();
                SOLOnion.EVENT.updatePlayerBenefits(player);
                SOLOnion.EVENT.syncFoodList(player);
            }
        }
    }

    public boolean isAllowed(Level level, ItemStack food) {
        return this.foodItems.canPass(level, food);
    }

    public double getDiversity(LivingEntity entity, ItemStack food) {
        for (FoodProperty property : this.foodDiversity) {
            if (!property.ingredient.is(entity.level(), food)) continue;
            return property.diversity;
        }
        FoodProperties prop = (FoodProperties)food.get(DataComponents.FOOD);
        if (prop != null) {
            double diversity = (double)prop.nutrition() / this.complexityStandardNutrition * ((double)prop.saturation() / this.complexityStandardSaturation);
            Consumable consum = (Consumable)food.get(DataComponents.CONSUMABLE);
            if (consum != null && consum.animation() == ItemUseAnimation.EAT) {
                for (ConsumeEffect c : consum.onConsumeEffects()) {
                    if (!(c instanceof ApplyStatusEffectsConsumeEffect)) continue;
                    ApplyStatusEffectsConsumeEffect effects = (ApplyStatusEffectsConsumeEffect)c;
                    for (MobEffectInstance effect : effects.effects()) {
                        diversity += (double)(effect.getAmplifier() + 1) * this.getModifierPerCategory(((MobEffect)effect.getEffect().value()).getCategory()) * (double)effects.probability();
                    }
                }
            }
            return diversity;
        }
        return 0.0;
    }

    public double getModifierPerCategory(MobEffectCategory category) {
        return switch (category) {
            default -> throw new MatchException(null, null);
            case MobEffectCategory.BENEFICIAL -> this.complexityBenefitEffectModifier;
            case MobEffectCategory.NEUTRAL -> this.complexityNeutralEffectModifier;
            case MobEffectCategory.HARMFUL -> this.complexityHarmEffectModifier;
        };
    }

    static {
        ConfigTypeConveration.registerTypeCreator(BenefitThreshold.class, () -> new BenefitThreshold(3.0, new BenefitAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, 2.0)));
        ConfigTypeConveration.registerTypeCreator(FoodProperty.class, () -> new FoodProperty((CreativeIngredient)new CreativeIngredientItem(Items.GOLDEN_CARROT), 2.0));
    }
}

