/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectConfig;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.solonion.common.benefit.Benefit;
import team.creative.solonion.common.benefit.BenefitType;
import team.creative.solonion.common.mod.FirstAidManager;

public class BenefitAttribute
extends Benefit<Attribute> {
    public final AttributeModifier.Operation operation;

    public BenefitAttribute(ResourceLocation location, double value, AttributeModifier.Operation op) {
        super(new RegistryObjectConfig(BuiltInRegistries.ATTRIBUTE, location), value);
        this.operation = op;
    }

    public BenefitAttribute(Holder<Attribute> holder, double value, AttributeModifier.Operation op) {
        this(((ResourceKey)holder.unwrapKey().get()).location(), value);
    }

    public BenefitAttribute(ResourceLocation location, double value) {
        this(location, value, AttributeModifier.Operation.ADD_VALUE);
    }

    public BenefitAttribute(Holder<Attribute> holder, double value) {
        this(holder, value, AttributeModifier.Operation.ADD_VALUE);
    }

    public BenefitAttribute(CompoundTag nbt) {
        super(BuiltInRegistries.ATTRIBUTE, nbt);
        this.operation = (AttributeModifier.Operation)AttributeModifier.Operation.BY_ID.apply(nbt.getIntOr("op", 0));
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = super.save();
        nbt.putInt("op", this.operation.ordinal());
        return nbt;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof BenefitAttribute) {
            BenefitAttribute att = (BenefitAttribute)obj;
            return att.operation == this.operation;
        }
        return false;
    }

    private record AttributeHolder(Holder<Attribute> attribute, AttributeModifier.Operation operation) {
    }

    public static class BenefitTypeAttribute
    extends BenefitType<BenefitAttribute, Object2DoubleMap<AttributeHolder>, HashMap<AttributeHolder, AttributeModifier>> {
        public BenefitTypeAttribute(Function<CompoundTag, BenefitAttribute> factory) {
            super(factory);
        }

        @Override
        public Registry registry() {
            return BuiltInRegistries.ATTRIBUTE;
        }

        @Override
        public void createControls(GuiParent parent, IGuiConfigParent configParent) {
            parent.add((GuiControl)new GuiStateButton((IGuiParent)parent, "operation", (IComponentMap)new TextMapBuilder().addComponent((Object[])AttributeModifier.Operation.values(), x -> Component.translatable((String)("config.solonion." + x.getSerializedName())))));
        }

        @Override
        public void loadValue(BenefitAttribute value, GuiParent parent, IGuiConfigParent configParent) {
            GuiStateButton op = (GuiStateButton)parent.get("operation");
            op.select((Object)value.operation);
        }

        @Override
        public BenefitAttribute saveValue(ResourceLocation location, double value, GuiParent parent, IGuiConfigParent configParent) {
            GuiStateButton op = (GuiStateButton)parent.get("operation");
            return new BenefitAttribute(location, value, (AttributeModifier.Operation)op.selected());
        }

        @Override
        public Object2DoubleMap<AttributeHolder> createStack() {
            return new Object2DoubleArrayMap();
        }

        @Override
        public void addToStack(BenefitAttribute value, Object2DoubleMap<AttributeHolder> stack) {
            if (value.operation == AttributeModifier.Operation.ADD_VALUE) {
                stack.compute((Object)new AttributeHolder((Holder<Attribute>)value.property.getHolder(), value.operation), (x, y) -> y != null ? y + value.value : value.value);
            } else {
                stack.compute((Object)new AttributeHolder((Holder<Attribute>)value.property.getHolder(), value.operation), (x, y) -> y != null ? Math.max(y, value.value) : value.value);
            }
        }

        @Override
        public boolean isEmpty(Object2DoubleMap<AttributeHolder> stack) {
            return stack.isEmpty();
        }

        @Override
        public HashMap<AttributeHolder, AttributeModifier> createApplied() {
            return new HashMap<AttributeHolder, AttributeModifier>();
        }

        @Override
        public void clearApplied(HashMap<AttributeHolder, AttributeModifier> applied) {
            applied.clear();
        }

        @Override
        public void saveApplied(HashMap<AttributeHolder, AttributeModifier> applied, ValueOutput output) {
            ValueOutput.ValueOutputList list = output.childrenList(this.getId());
            for (Map.Entry<AttributeHolder, AttributeModifier> entry : applied.entrySet()) {
                ValueOutput child = list.addChild();
                child.putString("att", entry.getKey().attribute.getRegisteredName());
                child.putInt("op", entry.getKey().operation.ordinal());
                child.store("mod", AttributeModifier.CODEC, (Object)entry.getValue());
            }
        }

        @Override
        public void loadApplied(HashMap<AttributeHolder, AttributeModifier> applied, ValueInput input) {
            Optional list = input.childrenList(this.getId());
            if (list.isPresent()) {
                ((ValueInput.ValueInputList)list.get()).forEach(child -> {
                    Holder.Reference att = (Holder.Reference)BuiltInRegistries.ATTRIBUTE.get(ResourceLocation.parse((String)child.getStringOr("att", ""))).get();
                    if (att != null) {
                        applied.put(new AttributeHolder((Holder<Attribute>)att, (AttributeModifier.Operation)AttributeModifier.Operation.BY_ID.apply(child.getIntOr("op", 0))), (AttributeModifier)child.read("mod", AttributeModifier.CODEC).orElseThrow());
                    }
                });
            }
        }

        @Override
        public boolean apply(Player player, HashMap<AttributeHolder, AttributeModifier> applied, @Nullable Object2DoubleMap<AttributeHolder> stack) {
            float oldMax = player.getMaxHealth();
            if (!applied.isEmpty()) {
                for (Map.Entry entry : applied.entrySet()) {
                    player.getAttribute(((AttributeHolder)entry.getKey()).attribute).removeModifier(((AttributeModifier)entry.getValue()).id());
                }
                applied.clear();
            }
            if (stack != null) {
                for (Object2DoubleMap.Entry entry : stack.object2DoubleEntrySet()) {
                    ResourceLocation location = ResourceLocation.tryBuild((String)"solonion", (String)((AttributeHolder)entry.getKey()).operation.toString().toLowerCase());
                    AttributeInstance att = player.getAttribute(((AttributeHolder)entry.getKey()).attribute);
                    att.removeModifier(location);
                    AttributeModifier modi = new AttributeModifier(location, entry.getDoubleValue(), ((AttributeHolder)entry.getKey()).operation);
                    if (att == null) continue;
                    att.addPermanentModifier(modi);
                    applied.put((AttributeHolder)entry.getKey(), modi);
                    if (((AttributeHolder)entry.getKey()).attribute != Attributes.MAX_HEALTH || FirstAidManager.INSTALLED) continue;
                    float newHealth = player.getHealth() * player.getMaxHealth() / oldMax;
                    player.setHealth(newHealth);
                }
            }
            return applied.isEmpty();
        }
    }
}

