/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectConfig;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.benefit.Benefit;
import team.creative.solonion.common.benefit.BenefitType;

public class BenefitMobEffect
extends Benefit<MobEffect> {
    public BenefitMobEffect(ResourceLocation location, double value) {
        super(new RegistryObjectConfig(BuiltInRegistries.MOB_EFFECT, location), value);
    }

    public BenefitMobEffect(Holder<MobEffect> holder, double value) {
        this(((ResourceKey)holder.unwrapKey().get()).location(), value);
    }

    public BenefitMobEffect(CompoundTag nbt) {
        super(BuiltInRegistries.MOB_EFFECT, nbt);
    }

    private static class AppliedMobEffects
    implements Iterable<Holder<MobEffect>> {
        private List<Holder<MobEffect>> list = new ArrayList<Holder<MobEffect>>();
        boolean reseting;

        private AppliedMobEffects() {
        }

        public void clear() {
            this.list.clear();
        }

        public void add(Holder<MobEffect> effect) {
            this.list.add(effect);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean contains(Holder<MobEffect> effect) {
            return this.list.contains(effect);
        }

        @Override
        public Iterator<Holder<MobEffect>> iterator() {
            return this.list.iterator();
        }
    }

    public static class BenefitTypeMobEffect
    extends BenefitType<BenefitMobEffect, Object2IntMap<Holder<MobEffect>>, AppliedMobEffects> {
        public BenefitTypeMobEffect(Function<CompoundTag, BenefitMobEffect> factory) {
            super(factory);
            NeoForge.EVENT_BUS.addListener(this::onEffectRemove);
        }

        public void onEffectRemove(MobEffectEvent.Remove event) {
            Player player;
            AppliedMobEffects applied;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && (applied = SOLOnionAPI.getBenefitCapability(player = (Player)livingEntity).getApplied(this)) != null && !applied.reseting && applied.contains((Holder<MobEffect>)event.getEffect())) {
                event.setCanceled(true);
            }
        }

        @Override
        public Registry registry() {
            return BuiltInRegistries.MOB_EFFECT;
        }

        @Override
        public void createControls(GuiParent parent, IGuiConfigParent configParent) {
        }

        @Override
        public void loadValue(BenefitMobEffect value, GuiParent parent, IGuiConfigParent configParent) {
        }

        @Override
        public BenefitMobEffect saveValue(ResourceLocation location, double value, GuiParent parent, IGuiConfigParent configParent) {
            return new BenefitMobEffect(location, value);
        }

        @Override
        public Object2IntMap<Holder<MobEffect>> createStack() {
            return new Object2IntArrayMap();
        }

        @Override
        public void addToStack(BenefitMobEffect value, Object2IntMap<Holder<MobEffect>> stack) {
            stack.compute((Object)value.property.getHolder(), (x, y) -> y != null ? Math.max(y, (int)value.value) : (int)value.value);
        }

        @Override
        public boolean isEmpty(Object2IntMap<Holder<MobEffect>> stack) {
            return stack.isEmpty();
        }

        @Override
        public AppliedMobEffects createApplied() {
            return new AppliedMobEffects();
        }

        @Override
        public void clearApplied(AppliedMobEffects applied) {
            applied.clear();
        }

        @Override
        public void saveApplied(AppliedMobEffects applied, ValueOutput output) {
            ValueOutput.TypedOutputList list = output.list(this.getId(), BuiltInRegistries.MOB_EFFECT.holderByNameCodec());
            for (Holder<MobEffect> effect : applied) {
                list.add(effect);
            }
        }

        @Override
        public void loadApplied(AppliedMobEffects applied, ValueInput input) {
            Optional list = input.list(this.getId(), BuiltInRegistries.MOB_EFFECT.holderByNameCodec());
            if (list.isPresent()) {
                ((ValueInput.TypedInputList)list.get()).forEach(applied::add);
            }
        }

        @Override
        public boolean apply(Player player, AppliedMobEffects applied, @Nullable Object2IntMap<Holder<MobEffect>> stack) {
            applied.reseting = true;
            if (!applied.isEmpty()) {
                for (Holder<MobEffect> effect : applied) {
                    player.removeEffect(effect);
                }
                applied.clear();
            }
            applied.reseting = false;
            if (stack != null) {
                for (Object2IntMap.Entry entry : stack.object2IntEntrySet()) {
                    MobEffectInstance in = new MobEffectInstance((Holder)entry.getKey(), -1, entry.getIntValue(), false, false);
                    if (!player.addEffect(in)) continue;
                    applied.add((Holder<MobEffect>)((Holder)entry.getKey()));
                }
            }
            return applied.isEmpty();
        }
    }
}

