/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.item.foodcontainer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import team.creative.creativecore.common.util.inventory.InventoryUtils;
import team.creative.creativecore.common.util.type.list.TupleList;
import team.creative.solonion.api.FoodPlayerData;
import team.creative.solonion.api.OnionFoodContainer;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.item.foodcontainer.FoodContainerProvider;
import team.creative.solonion.common.mod.OriginsManager;

public class FoodContainerItem
extends Item
implements OnionFoodContainer {
    private String displayName;
    public final int nslots;

    public FoodContainerItem(Item.Properties p, int nslots, String displayName) {
        super(p.useItemDescriptionPrefix().stacksTo(1).food(new FoodProperties.Builder().build()));
        this.displayName = displayName;
        this.nslots = nslots;
    }

    public InteractionResult useOn(UseOnContext context) {
        ResourceHandler handler = (ResourceHandler)Capabilities.Item.BLOCK.getCapability(context.getLevel(), context.getClickedPos(), null, null, (Object)context.getClickedFace());
        if (handler == null) {
            return super.useOn(context);
        }
        ResourceHandler inv = (ResourceHandler)context.getItemInHand().getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)context.getItemInHand()));
        TupleList bestStacks = new TupleList();
        for (int i = 0; i < handler.size(); ++i) {
            ItemResource resource = (ItemResource)handler.getResource(i);
            if (resource.isEmpty() || resource.get(DataComponents.FOOD) == null || !OriginsManager.isEdible(context.getPlayer(), resource.toStack(handler.getAmountAsInt(i)))) continue;
            for (int j = 0; j < inv.size(); ++j) {
                ItemResource toBeStacked = (ItemResource)inv.getResource(j);
                if (!resource.is((Object)toBeStacked.getItem()) || !resource.getComponents().equals((Object)toBeStacked.getComponents())) continue;
                int maxStackSize = Math.min(resource.getMaxStackSize(), inv.getCapacityAsInt(j, (Resource)toBeStacked));
                if (toBeStacked.isEmpty() || inv.getAmountAsInt(j) >= maxStackSize) continue;
                try (Transaction tx = Transaction.open(null);){
                    inv.insert(j, (Resource)toBeStacked, handler.extract(i, (Resource)resource, maxStackSize - inv.getAmountAsInt(j), (TransactionContext)tx), (TransactionContext)tx);
                    tx.commit();
                }
                if (handler.getAmountAsInt(i) <= 0) break;
            }
            bestStacks.add((Object)SOLOnion.CONFIG.getDiversity((LivingEntity)context.getPlayer(), resource.toStack(handler.getAmountAsInt(i))), (Object)i);
        }
        bestStacks.sort(Comparator.comparingDouble(x -> (Double)x.key));
        Iterator iterator = bestStacks.values().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            Transaction tx = Transaction.open(null);
            try {
                ItemResource resource = (ItemResource)handler.getResource(slot);
                int stack = handler.extract(slot, (Resource)resource, handler.getAmountAsInt(slot), (TransactionContext)tx);
                stack -= inv.insert((Resource)resource, stack, (TransactionContext)tx);
                if (stack > 0) {
                    handler.insert((Resource)resource, stack, (TransactionContext)tx);
                    break;
                }
                tx.commit();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        context.getItemInHand().set(DataComponents.CONTAINER, (Object)InventoryUtils.asContent((ResourceHandler)inv));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide() && player.isCrouching()) {
            player.openMenu((MenuProvider)new FoodContainerProvider(this.displayName), player.blockPosition());
        }
        if (!player.isCrouching()) {
            return this.processRightClick(world, player, hand);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult processRightClick(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (FoodContainerItem.isInventoryEmpty(player, stack)) {
            return InteractionResult.PASS;
        }
        if (player.canEat(false)) {
            player.startUsingItem(hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private static boolean isInventoryEmpty(Player player, ItemStack container) {
        ItemContainerContents handler = FoodContainerItem.getInventory(container);
        if (handler == null) {
            return true;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || stack.get(DataComponents.FOOD) == null || !OriginsManager.isEdible(player, stack)) continue;
            return false;
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        tooltip.accept((Component)Component.translatable((String)"item.solonion.container.open", (Object[])new Object[]{Component.keybind((String)"key.sneak"), Component.keybind((String)"key.use")}));
        super.appendHoverText(stack, context, display, tooltip, flag);
    }

    @Nullable
    public static ItemContainerContents getInventory(ItemStack bag) {
        Item item = bag.getItem();
        if (item instanceof FoodContainerItem) {
            FoodContainerItem item2 = (FoodContainerItem)item;
            if (bag.has(DataComponents.CONTAINER)) {
                return (ItemContainerContents)bag.get(DataComponents.CONTAINER);
            }
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(item2.nslots);
            for (int i = 0; i < item2.nslots; ++i) {
                stacks.add(ItemStack.EMPTY);
            }
            ItemContainerContents contents = ItemContainerContents.fromItems(stacks);
            bag.set(DataComponents.CONTAINER, (Object)contents);
            return contents;
        }
        return null;
    }

    @Override
    public ItemStack getActualFood(Player player, ItemStack stack) {
        ItemContainerContents handler = FoodContainerItem.getInventory(stack);
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        int bestFoodSlot = FoodContainerItem.getBestFoodSlot(handler, player);
        if (bestFoodSlot < 0) {
            return ItemStack.EMPTY;
        }
        return handler.getStackInSlot(bestFoodSlot).copy();
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ItemContainerContents handler = FoodContainerItem.getInventory(stack);
        if (handler == null) {
            return stack;
        }
        int bestFoodSlot = FoodContainerItem.getBestFoodSlot(handler, player);
        if (bestFoodSlot < 0) {
            return stack;
        }
        NonNullList newInventory = NonNullList.withSize((int)handler.getSlots(), (Object)ItemStack.EMPTY);
        handler.copyInto(newInventory);
        ItemStack bestFood = handler.getStackInSlot(bestFoodSlot);
        ItemStack foodCopy = bestFood.copy();
        if (bestFood.get(DataComponents.FOOD) != null && !bestFood.isEmpty() && OriginsManager.isEdible(player, foodCopy)) {
            ItemStack result = bestFood.finishUsingItem(world, entity);
            newInventory.set(bestFoodSlot, (Object)result);
            if (result.get(DataComponents.FOOD) == null) {
                newInventory.set(bestFoodSlot, (Object)ItemStack.EMPTY);
                Player playerEntity = (Player)entity;
                if (!playerEntity.getInventory().add(result)) {
                    playerEntity.drop(result, false);
                }
            }
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)newInventory));
            if (!world.isClientSide()) {
                EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)foodCopy, (int)0, (ItemStack)result);
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public static int getBestFoodSlot(ItemContainerContents handler, Player player) {
        FoodPlayerData foodList = SOLOnionAPI.getFoodCapability(player);
        double maxDiversity = -1.7976931348623157E308;
        int bestFoodSlot = -1;
        for (int i = 0; i < handler.getSlots(); ++i) {
            double diversityChange;
            ItemStack food = handler.getStackInSlot(i);
            if (food.get(DataComponents.FOOD) == null || food.isEmpty() || !OriginsManager.isEdible(player, food) || !((diversityChange = foodList.simulateEat((LivingEntity)player, food)) > maxDiversity)) continue;
            maxDiversity = diversityChange;
            bestFoodSlot = i;
        }
        return bestFoodSlot;
    }
}

