/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plamoneyget;

import com.mojang.logging.LogUtils;
import com.pla.plamoneyget.Config;
import com.pla.plamoneyget.Data;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.sixik.sdmeconomy.economyData.CurrencyPlayerData;
import net.sixik.sdmeconomy.utils.ErrorCodes;
import org.slf4j.Logger;

@EventBusSubscriber(modid="plamoneyget")
public class MobLootHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Mob, UUID> lastAttackers = new HashMap<Mob, UUID>();

    @SubscribeEvent
    public static void onMobHurt(LivingDamageEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        lastAttackers.put(mob, player.getUUID());
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (mob.level().isClientSide) {
            return;
        }
        ResourceLocation mobId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType());
        if (mobId == null) {
            return;
        }
        String id = mobId.toString();
        List blackList = (List)Config.BLACK_LIST.get();
        List whiteList = (List)Config.WHITE_LIST.get();
        if (blackList.contains(id)) {
            return;
        }
        if (!(mob instanceof Enemy) && !whiteList.contains(id)) {
            return;
        }
        double health = entity.getMaxHealth();
        if (health < (double)((Integer)Config.MIN_HEALTH.get()).intValue()) {
            return;
        }
        ServerPlayer pPlayer = null;
        Entity entity2 = event.getSource().getEntity();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer directPlayer;
            pPlayer = directPlayer = (ServerPlayer)entity2;
        } else if (lastAttackers.containsKey(mob)) {
            UUID playerUUID = lastAttackers.get(mob);
            pPlayer = mob.getServer().getPlayerList().getPlayer(playerUUID);
        }
        if (pPlayer == null) {
            return;
        }
        int moneyAmount = (int)(health / (Double)Config.DIVISOR.get());
        ErrorCodes result = CurrencyPlayerData.SERVER.addCurrencyValue((Player)pPlayer, "sdmcoin", (double)moneyAmount);
        switch (result) {
            case SUCCESS: {
                PacketDistributor.sendToPlayer((ServerPlayer)pPlayer, (CustomPacketPayload)new Data(String.valueOf(moneyAmount)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case NOT_FOUND: {
                LOGGER.error("\u00a7cCurrency sdmcoin not found.");
                break;
            }
            case FAIL: {
                LOGGER.error("\u00a7cFailed to add currency due to internal error.");
                break;
            }
            default: {
                LOGGER.error("\u00a7cUnknown error: " + String.valueOf(result));
            }
        }
    }
}

