/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plamoneyget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class MoneyPickupOverlay {
    private static final List<PickupMessage> messages = new ArrayList<PickupMessage>();
    private static final int MESSAGE_LIFETIME = 3000;

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        int x = mc.m_91268_().m_85445_() - 100;
        int y = mc.m_91268_().m_85446_() - 40;
        long currentTime = System.currentTimeMillis();
        messages.removeIf(msg -> currentTime - msg.timestamp > 3000L);
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Font font = mc.f_91062_;
        for (PickupMessage msg2 : messages) {
            guiGraphics.m_280430_(font, msg2.text, x, y, msg2.color);
            y -= 12;
        }
    }

    public static void addPickupMessage(String message, ChatFormatting color) {
        messages.add(new PickupMessage((Component)Component.m_237113_((String)message).m_130938_(style -> style.m_131140_(color)), System.currentTimeMillis(), color.m_126665_()));
    }

    private static class PickupMessage {
        final Component text;
        final long timestamp;
        final int color;

        PickupMessage(Component text, long timestamp, int color) {
            this.text = text;
            this.timestamp = timestamp;
            this.color = color;
        }
    }
}

