/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plamoneyget;

import com.mojang.logging.LogUtils;
import com.pla.plamoneyget.MoneyMessage;
import com.pla.plamoneyget.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.sdm.sdmshopr.SDMShopR;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="plamoneyget")
public class MobLootHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Mob, UUID> lastAttackers = new HashMap<Mob, UUID>();

    @SubscribeEvent
    public static void onMobHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        lastAttackers.put(mob, player.m_20148_());
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        ServerPlayer pPlayer;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (!(mob instanceof Enemy)) {
            return;
        }
        double health = entity.m_21233_();
        if (health < 20.0) {
            return;
        }
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer directPlayer;
            pPlayer = directPlayer = (ServerPlayer)entity2;
        } else if (lastAttackers.containsKey(mob)) {
            UUID playerUUID = lastAttackers.get(mob);
            pPlayer = mob.m_20194_().m_6846_().m_11259_(playerUUID);
        } else {
            pPlayer = null;
        }
        if (pPlayer == null) {
            return;
        }
        if (health >= 20.0) {
            int moneyAmount = (int)health / 10;
            SDMShopR.addMoney((ServerPlayer)pPlayer, (long)moneyAmount);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> pPlayer), (Object)new MoneyMessage(moneyAmount));
        }
    }
}

