/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plamoneyget;

import com.pla.plamoneyget.MoneyPickupOverlay;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MoneyMessage {
    private final int amount;

    public MoneyMessage(int amount) {
        this.amount = amount;
    }

    public static void encode(MoneyMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.amount);
    }

    public static MoneyMessage decode(FriendlyByteBuf buf) {
        return new MoneyMessage(buf.readInt());
    }

    public static void handle(MoneyMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MoneyPickupOverlay.addPickupMessage("\u25ce Money x" + msg.amount, ChatFormatting.GREEN)));
        ctx.get().setPacketHandled(true);
    }
}

