/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plamoneyget;

import com.mojang.logging.LogUtils;
import com.pla.plamoneyget.Config;
import com.pla.plamoneyget.MoneyMessage;
import com.pla.plamoneyget.PacketHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.sdm.sdmshopr.SDMShopR;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="plamoneyget")
public class MobLootHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Mob, UUID> lastAttackers = new HashMap<Mob, UUID>();

    @SubscribeEvent
    public static void onMobHurt(LivingHurtEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        Entity entity2 = event.getSource().m_7639_();
        if (!(entity2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity2;
        lastAttackers.put(mob, player.m_142081_());
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        ServerPlayer pPlayer;
        LivingEntity entity = (LivingEntity)event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        ResourceLocation mobId = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)mob.m_6095_());
        if (mobId == null) {
            return;
        }
        String id = mobId.toString();
        List blackList = (List)Config.BLACK_LIST.get();
        List whiteList = (List)Config.WHITE_LIST.get();
        if (blackList.contains(id)) {
            return;
        }
        if (!(mob instanceof Enemy) && !whiteList.contains(id)) {
            return;
        }
        double health = entity.m_21233_();
        if (health < (double)((Integer)Config.MIN_HEALTH.get()).intValue()) {
            return;
        }
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer directPlayer;
            pPlayer = directPlayer = (ServerPlayer)entity2;
        } else if (lastAttackers.containsKey(mob)) {
            UUID playerUUID = lastAttackers.get(mob);
            pPlayer = mob.m_20194_().m_6846_().m_11259_(playerUUID);
        } else {
            pPlayer = null;
        }
        if (pPlayer == null) {
            return;
        }
        int moneyAmount = (int)health / (Integer)Config.DIVISOR.get();
        SDMShopR.addMoney((ServerPlayer)pPlayer, (long)moneyAmount);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> pPlayer), (Object)new MoneyMessage(moneyAmount));
    }
}

