/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plamoneyget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class MoneyPickupOverlay {
    private static final List<PickupMessage> messages = new ArrayList<PickupMessage>();
    private static final int MESSAGE_LIFETIME = 3000;

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        int x = mc.m_91268_().m_85445_() - 100;
        int y = mc.m_91268_().m_85446_() - 40;
        long currentTime = System.currentTimeMillis();
        messages.removeIf(msg -> currentTime - msg.timestamp > 3000L);
        PoseStack poseStack = event.getMatrixStack();
        Font font = mc.f_91062_;
        for (PickupMessage msg2 : messages) {
            font.m_92889_(poseStack, (Component)msg2.text, (float)x, (float)y, msg2.color);
            y -= 12;
        }
    }

    public static void addPickupMessage(String message, ChatFormatting color) {
        messages.add(new PickupMessage((TextComponent)new TextComponent(message).m_130940_(color), System.currentTimeMillis(), color.m_126665_()));
    }

    private static class PickupMessage {
        final TextComponent text;
        final long timestamp;
        final int color;

        PickupMessage(TextComponent text, long timestamp, int color) {
            this.text = text;
            this.timestamp = timestamp;
            this.color = color;
        }
    }
}

