/*
 * Decompiled with CFR 0.152.
 */
package com.pla.plamoneyget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(modid="plamoneyget", value={Dist.CLIENT})
public class MoneyPickupOverlay {
    private static final List<PickupMessage> messages = new ArrayList<PickupMessage>();
    private static final int MESSAGE_LIFETIME = 3000;

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        int x = mc.getWindow().getGuiScaledWidth() - 100;
        int y = mc.getWindow().getGuiScaledHeight() - 40;
        long currentTime = System.currentTimeMillis();
        messages.removeIf(msg -> currentTime - msg.timestamp > 3000L);
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Font font = mc.font;
        for (PickupMessage msg2 : messages) {
            guiGraphics.drawString(font, msg2.text, x, y, msg2.color);
            y -= 12;
        }
    }

    public static void addPickupMessage(String message, ChatFormatting color) {
        messages.add(new PickupMessage((Component)Component.literal((String)message).withStyle(style -> style.withColor(color)), System.currentTimeMillis(), color.getColor()));
    }

    private static class PickupMessage {
        final Component text;
        final long timestamp;
        final int color;

        PickupMessage(Component text, long timestamp, int color) {
            this.text = text;
            this.timestamp = timestamp;
            this.color = color;
        }
    }
}

