/*
 * Decompiled with CFR 0.152.
 */
package xyz.bitsquidd.ninja;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2596;
import org.jspecify.annotations.NullMarked;
import xyz.bitsquidd.ninja.PacketRegistry;
import xyz.bitsquidd.ninja.handler.PacketHandler;

@NullMarked
@Environment(value=EnvType.CLIENT)
public final class PacketFilter {
    private final Map<Class<? extends class_2596<?>>, Boolean> packetFilters = new ConcurrentHashMap();

    public PacketFilter() {
        for (Class<? extends class_2596<?>> clazz : PacketRegistry.getAllPacketClasses()) {
            this.packetFilters.put(clazz, false);
        }
    }

    public boolean shouldInterceptPacket(Class<?> packetClass) {
        return this.packetFilters.getOrDefault(packetClass, false) != false && PacketRegistry.canHandle(packetClass);
    }

    public boolean shouldInterceptPacket(class_2596<?> packet) {
        return this.shouldInterceptPacket(packet.getClass());
    }

    public void togglePacketFilter(String packetName) {
        PacketHandler<?> handler = PacketRegistry.findHandler(packetName);
        if (handler != null) {
            Class<?> packetClass;
            boolean currentState = this.packetFilters.getOrDefault(packetClass = handler.getPacketClass(), false);
            this.packetFilters.put(packetClass, !currentState);
        }
    }

    public boolean isPacketEnabled(Class<? extends class_2596<?>> packetClass) {
        return this.packetFilters.getOrDefault(packetClass, false);
    }

    public Set<Class<? extends class_2596<?>>> getKnownPackets() {
        return PacketRegistry.getAllPacketClasses();
    }
}

