/*
 * Decompiled with CFR 0.152.
 */
package xyz.bitsquidd.ninja;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2596;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.bitsquidd.ninja.PacketFilter;
import xyz.bitsquidd.ninja.command.PacketInterceptionCommand;
import xyz.bitsquidd.ninja.format.PacketLogger;

@Environment(value=EnvType.CLIENT)
public final class PacketInterceptorMod
implements ClientModInitializer {
    public static final String MOD_ID = "packet-interceptor";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"packet-interceptor");
    private static PacketInterceptorMod instance;
    private final PacketFilter packetFilter = new PacketFilter();
    private final PacketLogger packetLogger = new PacketLogger();
    public static boolean logPackets;

    public PacketInterceptorMod() {
        instance = this;
    }

    @NotNull
    public static PacketInterceptorMod getInstance() {
        return instance;
    }

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> PacketInterceptionCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    @NotNull
    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    @NotNull
    public PacketLogger getPacketLogger() {
        return this.packetLogger;
    }

    public static void logPacket(class_2596<?> packet) {
        if (logPackets && PacketInterceptorMod.getInstance().getPacketFilter().shouldInterceptPacket(packet)) {
            PacketInterceptorMod.getInstance().getPacketLogger().addPacket(packet);
        }
    }

    static {
        logPackets = false;
    }
}

