/*
 * Decompiled with CFR 0.152.
 */
package xyz.bitsquidd.ninja;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2596;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import xyz.bitsquidd.ninja.handler.PacketHandler;

@NullMarked
@Environment(value=EnvType.CLIENT)
public final class PacketRegistry {
    private static final Map<Class<? extends class_2596<?>>, PacketHandler<?>> handlers = new HashMap();
    private static final Map<String, PacketHandler<?>> nameToHandler = new HashMap();

    private static void registerHandlers() {
        try {
            String basePackage = "xyz.bitsquidd.ninja.handler.impl";
            Reflections reflections = new Reflections(basePackage, new Scanner[0]);
            Set handlerClasses = reflections.getSubTypesOf(PacketHandler.class);
            for (Class handlerClass : handlerClasses) {
                if (Modifier.isAbstract(handlerClass.getModifiers())) continue;
                PacketHandler handler = (PacketHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                PacketRegistry.registerHandler(handler);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register packet handlers via reflection", e);
        }
    }

    private static void registerHandler(PacketHandler<?> handler) {
        handlers.put(handler.getPacketClass(), handler);
        nameToHandler.put(handler.getFriendlyName().toLowerCase(), handler);
    }

    @Nullable
    public static PacketHandler<?> getHandlerForPacket(class_2596<?> packet) {
        return handlers.get(packet.getClass());
    }

    public static boolean canHandle(Class<?> packetClass) {
        return handlers.containsKey(packetClass);
    }

    public static boolean canHandle(class_2596<?> packet) {
        return PacketRegistry.canHandle(packet.getClass());
    }

    public static Collection<PacketHandler<?>> getAllHandlers() {
        ArrayList allHandlers = new ArrayList(handlers.values());
        allHandlers.sort(Comparator.comparing(PacketHandler::getFriendlyName));
        return allHandlers;
    }

    public static Set<Class<? extends class_2596<?>>> getAllPacketClasses() {
        return handlers.keySet();
    }

    @Nullable
    public static PacketHandler<?> findHandler(String input) {
        PacketHandler<?> handler = nameToHandler.get(input.toLowerCase());
        if (handler != null) {
            return handler;
        }
        for (PacketHandler<?> h : handlers.values()) {
            if (!h.getFriendlyName().toLowerCase().contains(input.toLowerCase())) continue;
            return h;
        }
        for (PacketHandler<?> h : handlers.values()) {
            if (!h.getPacketClass().getSimpleName().toLowerCase().contains(input.toLowerCase())) continue;
            return h;
        }
        return null;
    }

    static {
        PacketRegistry.registerHandlers();
    }
}

