/*
 * Decompiled with CFR 0.152.
 */
package xyz.bitsquidd.ninja.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.kyori.adventure.platform.modcommon.MinecraftClientAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import xyz.bitsquidd.ninja.PacketFilter;
import xyz.bitsquidd.ninja.PacketInterceptorMod;
import xyz.bitsquidd.ninja.PacketRegistry;
import xyz.bitsquidd.ninja.command.ResponseType;
import xyz.bitsquidd.ninja.handler.PacketHandler;

@Environment(value=EnvType.CLIENT)
public class PacketInterceptionCommand {
    private static final SuggestionProvider<FabricClientCommandSource> PACKET_SUGGESTIONS = (context, builder) -> {
        for (String friendlyName : PacketRegistry.getAllHandlers().stream().map(PacketHandler::getFriendlyName).toList()) {
            if (!friendlyName.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(friendlyName);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"packets").then(ClientCommandManager.literal((String)"start").executes(PacketInterceptionCommand::startLogging))).then(ClientCommandManager.literal((String)"stop").executes(PacketInterceptionCommand::stopLogging))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"filter").executes(PacketInterceptionCommand::listPackets)).then(ClientCommandManager.argument((String)"packetName", (ArgumentType)StringArgumentType.word()).suggests(PACKET_SUGGESTIONS).executes(PacketInterceptionCommand::togglePacket))));
    }

    private static void sendMessage(Component message, ResponseType responseType) {
        MinecraftClientAudiences.of().audience().sendMessage(((TextComponent)Component.empty().append((Component)Component.text((String)(responseType.icon + " ")))).append(message.color(responseType.color)));
    }

    public static void sendBlank() {
        MinecraftClientAudiences.of().audience().sendMessage((Component)Component.empty());
    }

    private static int startLogging(CommandContext<FabricClientCommandSource> ctx) {
        PacketInterceptorMod.logPackets = true;
        PacketInterceptionCommand.sendBlank();
        PacketInterceptionCommand.sendMessage((Component)Component.text((String)"Started packet logging..."), ResponseType.SUCCESS);
        return 1;
    }

    private static int stopLogging(CommandContext<FabricClientCommandSource> ctx) {
        PacketInterceptorMod.logPackets = false;
        PacketInterceptionCommand.sendBlank();
        PacketInterceptionCommand.sendMessage((Component)Component.text((String)"Stopped packet logging..."), ResponseType.ERROR);
        return 1;
    }

    private static int listPackets(CommandContext<FabricClientCommandSource> ctx) {
        PacketFilter filter = PacketInterceptorMod.getInstance().getPacketFilter();
        PacketInterceptionCommand.sendBlank();
        PacketInterceptionCommand.sendMessage(((TextComponent)Component.empty().append(Component.text((String)"Logging: ").decorate(TextDecoration.BOLD))).append((Component)Component.text((String)(PacketInterceptorMod.logPackets ? "ON" : "OFF"))), ResponseType.INFO);
        List<PacketHandler> enabledHandlers = PacketRegistry.getAllHandlers().stream().filter(handler -> filter.isPacketEnabled(handler.getPacketClass())).toList();
        List<PacketHandler> disabledHandlers = PacketRegistry.getAllHandlers().stream().filter(handler -> !filter.isPacketEnabled(handler.getPacketClass())).toList();
        if (!enabledHandlers.isEmpty()) {
            PacketInterceptionCommand.sendBlank();
            PacketInterceptionCommand.sendMessage((Component)Component.text((String)"Enabled: ").decorate(new TextDecoration[]{TextDecoration.BOLD, TextDecoration.UNDERLINED}), ResponseType.SUCCESS);
            for (PacketHandler handler2 : enabledHandlers) {
                PacketInterceptionCommand.sendMessage(((TextComponent)Component.empty().append(Component.text((String)(handler2.getFriendlyName() + ": ")).decorate(TextDecoration.BOLD))).append((Component)Component.text((String)handler2.getDescription())), ResponseType.SUCCESS);
            }
        }
        if (!disabledHandlers.isEmpty()) {
            PacketInterceptionCommand.sendBlank();
            PacketInterceptionCommand.sendMessage((Component)Component.text((String)"Disabled: ").decorate(new TextDecoration[]{TextDecoration.BOLD, TextDecoration.UNDERLINED}), ResponseType.ERROR);
            for (PacketHandler handler2 : disabledHandlers) {
                PacketInterceptionCommand.sendMessage(((TextComponent)Component.empty().append(Component.text((String)(handler2.getFriendlyName() + ": ")).decorate(TextDecoration.BOLD))).append((Component)Component.text((String)handler2.getDescription())), ResponseType.ERROR);
            }
        }
        return 1;
    }

    private static int togglePacket(CommandContext<FabricClientCommandSource> ctx) {
        String packetName = StringArgumentType.getString(ctx, (String)"packetName");
        PacketFilter filter = PacketInterceptorMod.getInstance().getPacketFilter();
        PacketHandler<?> handler = PacketRegistry.findHandler(packetName);
        if (handler == null) {
            PacketInterceptionCommand.sendMessage(((TextComponent)Component.empty().append(Component.text((String)"Unknown packet: ").decorate(TextDecoration.BOLD))).append((Component)Component.text((String)packetName)), ResponseType.ERROR);
            return 1;
        }
        filter.togglePacketFilter(handler.getFriendlyName());
        boolean isEnabled = filter.isPacketEnabled(handler.getPacketClass());
        if (isEnabled) {
            PacketInterceptionCommand.sendMessage(((TextComponent)Component.empty().append(Component.text((String)"Enabled interception for: ").decorate(TextDecoration.BOLD))).append((Component)Component.text((String)handler.getFriendlyName())), ResponseType.SUCCESS);
        } else {
            PacketInterceptionCommand.sendMessage(((TextComponent)Component.empty().append(Component.text((String)"Disabled interception for: ").decorate(TextDecoration.BOLD))).append((Component)Component.text((String)handler.getFriendlyName())), ResponseType.ERROR);
        }
        return 1;
    }
}

