/*
 * Decompiled with CFR 0.152.
 */
package xyz.bitsquidd.ninja.format;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import org.jspecify.annotations.NullMarked;
import xyz.bitsquidd.ninja.format.PacketInfoSegment;
import xyz.bitsquidd.ninja.handler.PacketType;

@NullMarked
@Environment(value=EnvType.CLIENT)
public final class PacketInfoBundle {
    private final PacketType type;
    private final Component name;
    private final List<PacketInfoSegment> segments;

    private PacketInfoBundle(PacketType type, Component name, List<PacketInfoSegment> segments) {
        this.type = type;
        this.name = name;
        this.segments = segments;
    }

    public static PacketInfoBundle of(PacketType type, Component name, List<PacketInfoSegment> segments) {
        return new PacketInfoBundle(type, name, segments);
    }

    public Component format() {
        Component titleComponent = ((TextComponent)Component.empty().append((Component)Component.text((String)(this.type.icon + " ")))).append(this.name.color(this.type.primaryColor).decorate(TextDecoration.BOLD));
        List segmentComponents = this.segments.stream().map(segment -> (TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().color(this.type.secondaryColor)).append((Component)Component.text((String)"    \u21aa "))).append(segment.getName())).append((Component)Component.text((String)": "))).append(segment.getValue())).collect(Collectors.toList());
        ArrayList<Component> allComponents = new ArrayList<Component>(List.of(titleComponent));
        allComponents.addAll(segmentComponents);
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), allComponents);
    }
}

