/*
 * Decompiled with CFR 0.152.
 */
package xyz.bitsquidd.ninja.format;

import java.time.Duration;
import java.time.Instant;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.modcommon.MinecraftClientAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.class_2596;
import org.jspecify.annotations.NullMarked;
import xyz.bitsquidd.ninja.PacketRegistry;
import xyz.bitsquidd.ninja.format.PacketInfoBundle;
import xyz.bitsquidd.ninja.handler.PacketHandler;

@NullMarked
@Environment(value=EnvType.CLIENT)
public final class PacketLogger {
    private Instant lastPacketTime = Instant.EPOCH;

    public void addPacket(class_2596<?> packet) {
        PacketHandler<?> handler = PacketRegistry.getHandlerForPacket(packet);
        if (handler == null) {
            return;
        }
        Instant currentTime = Instant.now();
        if (Duration.between(this.lastPacketTime, currentTime).compareTo(Duration.ofMillis(500L)) < 0) {
            this.sendChatMessage(Component.text((String)"...", (TextColor)NamedTextColor.GRAY).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Too many packets sent within 500ms, hiding."))));
        }
        this.lastPacketTime = currentTime;
        PacketInfoBundle infoBundle = handler.getPacketInfo(packet);
        this.sendChatMessage(infoBundle.format());
    }

    private void sendChatMessage(Component component) {
        Audience client = MinecraftClientAudiences.of().audience();
        client.sendMessage(component);
    }
}

