/*
 * Decompiled with CFR 0.152.
 */
package xyz.bitsquidd.ninja.handler;

import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2596;
import org.jspecify.annotations.NullMarked;
import xyz.bitsquidd.ninja.format.PacketInfoBundle;
import xyz.bitsquidd.ninja.handler.PacketType;

@NullMarked
@Environment(value=EnvType.CLIENT)
public abstract class PacketHandler<T extends class_2596<?>> {
    private static final int MAX_DISPLAYED_ENTRIES = 5;
    protected final Class<T> packetClass;
    protected final String friendlyName;
    protected final String description;
    protected final PacketType packetType;

    public PacketHandler(Class<T> packetClass, String friendlyName, String description, PacketType packetType) {
        this.packetClass = packetClass;
        this.friendlyName = friendlyName;
        this.description = description;
        this.packetType = packetType;
    }

    public final Class<T> getPacketClass() {
        return this.packetClass;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final boolean canHandle(class_2596<?> packet) {
        return this.packetClass.isInstance(packet);
    }

    public final PacketInfoBundle getPacketInfo(class_2596<?> packet) {
        if (!this.canHandle(packet)) {
            throw new IllegalArgumentException("Cannot handle packet of type: " + packet.getClass().getSimpleName());
        }
        return this.getPacketInfoInternal(packet);
    }

    protected abstract PacketInfoBundle getPacketInfoInternal(T var1);

    protected final String formatList(Collection<?> entries) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        List<String> entriesList = entries.stream().map(Object::toString).toList();
        int size = entriesList.size();
        boolean tooMany = size > 5;
        for (int i = 0; i < 5 && i < size; ++i) {
            sb.append(entriesList.get(i));
            if (i <= 0) continue;
            sb.append(",");
        }
        if (tooMany) {
            sb.append("...+").append(size - 5).append(" more]");
        } else {
            sb.append("]");
        }
        return sb.toString();
    }
}

