/*
 * Decompiled with CFR 0.152.
 */
package me.mejbha.dimensionShifter;

import me.mejbha.dimensionShifter.DimensionShifter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;

public class RespawnListener
implements Listener {
    private final DimensionShifter plugin;

    public RespawnListener(DimensionShifter plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Location bedSpawn = player.getRespawnLocation();
        if (bedSpawn != null) {
            event.setRespawnLocation(bedSpawn);
            return;
        }
        String defaultWorldName = this.plugin.getConfig().getString("default-respawn-world", "world");
        World defaultWorld = Bukkit.getWorld((String)defaultWorldName);
        if (defaultWorld != null) {
            Location spawnLocation = defaultWorld.getSpawnLocation();
            event.setRespawnLocation(spawnLocation);
        } else {
            this.plugin.getLogger().warning("Default respawn world '" + defaultWorldName + "' not found! Using fallback spawn.");
        }
    }
}

