/*
 * Decompiled with CFR 0.152.
 */
package me.mejbha.dimensionShifter;

import com.earth2me.essentials.Essentials;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.mejbha.dimensionShifter.DimensionShifter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpTask
extends BukkitRunnable {
    private final DimensionShifter plugin;
    private final Random random = new Random();
    private Essentials essentials;

    public WarpTask(DimensionShifter plugin) {
        this.plugin = plugin;
        Plugin essPlugin = Bukkit.getServer().getPluginManager().getPlugin("Essentials");
        if (essPlugin instanceof Essentials) {
            this.essentials = (Essentials)essPlugin;
        }
    }

    public void run() {
        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
        if (onlinePlayers.isEmpty()) {
            return;
        }
        int chance = this.plugin.getConfig().getInt("warp-chance", 100);
        if (this.random.nextInt(100) >= chance) {
            return;
        }
        Player player = (Player)onlinePlayers.get(this.random.nextInt(onlinePlayers.size()));
        World world = this.pickRandomWorld();
        if (world == null) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("warning.enabled", true)) {
            int countdown = this.plugin.getConfig().getInt("warning.countdown", 10);
            this.sendCountdown(player, countdown);
        } else {
            this.teleportPlayerSafe(player, world);
        }
    }

    private void sendCountdown(final Player player, final int countdown) {
        new BukkitRunnable(this){
            int timeLeft;
            final /* synthetic */ WarpTask this$0;
            {
                this.this$0 = this$0;
                this.timeLeft = countdown;
            }

            public void run() {
                if (this.timeLeft > 0) {
                    String message = this.this$0.plugin.getConfig().getString("warning.message", "&cWarning! Dimension shift in %time% seconds!").replace("%time%", String.valueOf(this.timeLeft));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                    --this.timeLeft;
                } else {
                    String finalMessage = this.this$0.plugin.getConfig().getString("warning.final-message", "&4Teleporting now!");
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)finalMessage));
                    this.this$0.teleportPlayerSafe(player, this.this$0.pickRandomWorld());
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void teleportPlayerSafe(Player player, World world) {
        if (world == null) {
            return;
        }
        Location safeLocation = this.getSafeLocation(world);
        if (safeLocation != null) {
            player.teleport(safeLocation);
        } else {
            player.sendMessage(ChatColor.RED + "Failed to find a safe teleport location!");
        }
    }

    private Location getSafeLocation(World world) {
        int maxTries = 50;
        int range = this.plugin.getConfig().getInt("teleport-range", 1000);
        for (int i = 0; i < maxTries; ++i) {
            int z;
            int x = this.random.nextInt(range * 2) - range;
            int y = this.getSafeY(world, x, z = this.random.nextInt(range * 2) - range);
            if (y == -1) continue;
            return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        }
        return world.getSpawnLocation();
    }

    private int getSafeY(World world, int x, int z) {
        if (world.getEnvironment() == World.Environment.NETHER) {
            return this.getNetherSafeY(world, x, z);
        }
        if (world.getEnvironment() == World.Environment.THE_END) {
            return this.getEndSafeY(world, x, z);
        }
        return this.getOverworldSafeY(world, x, z);
    }

    private int getNetherSafeY(World world, int x, int z) {
        for (int y = 124; y > 5; --y) {
            Block block = world.getBlockAt(x, y, z);
            Block above = world.getBlockAt(x, y + 1, z);
            Block below = world.getBlockAt(x, y - 1, z);
            if (!this.isSafeBlock(block) || !below.getType().isSolid() || above.getType() != Material.AIR) continue;
            return y;
        }
        return -1;
    }

    private int getEndSafeY(World world, int x, int z) {
        for (int y = world.getHighestBlockYAt(x, z); y > 0; --y) {
            Block block = world.getBlockAt(x, y, z);
            if (block.getType() != Material.END_STONE) continue;
            return y + 1;
        }
        return -1;
    }

    private int getOverworldSafeY(World world, int x, int z) {
        for (int y = world.getHighestBlockYAt(x, z); y > 5; --y) {
            Block block = world.getBlockAt(x, y, z);
            Block below = world.getBlockAt(x, y - 1, z);
            Block above = world.getBlockAt(x, y + 1, z);
            if (!this.isSafeBlock(block) || !below.getType().isSolid() || above.getType() != Material.AIR) continue;
            return y;
        }
        return -1;
    }

    private boolean isSafeBlock(Block block) {
        Material type = block.getType();
        return type != Material.LAVA && type != Material.FIRE && type != Material.WATER && type != Material.CACTUS && type != Material.MAGMA_BLOCK && type != Material.CAMPFIRE && type != Material.SOUL_CAMPFIRE && type != Material.POWDER_SNOW && type != Material.AIR;
    }

    private World pickRandomWorld() {
        List allowedWorlds = this.plugin.getConfig().getStringList("allowed-worlds");
        if (allowedWorlds.isEmpty()) {
            return null;
        }
        String worldName = (String)allowedWorlds.get(this.random.nextInt(allowedWorlds.size()));
        return Bukkit.getWorld((String)worldName);
    }
}

