/*
 * Decompiled with CFR 0.152.
 */
package com.github.scotsguy.nowplaying;

import com.github.scotsguy.nowplaying.config.Config;
import com.github.scotsguy.nowplaying.gui.toast.NowPlayingToast;
import com.github.scotsguy.nowplaying.mixin.accessor.GuiAccessor;
import com.github.scotsguy.nowplaying.mixin.accessor.MinecraftAccessor;
import com.github.scotsguy.nowplaying.mixin.accessor.ToastManagerAccessor;
import com.github.scotsguy.nowplaying.util.Localization;
import com.github.scotsguy.nowplaying.util.ModLogger;
import com.github.scotsguy.nowplaying.util.SpriteProvider;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class NowPlaying {
    public static final String MOD_ID = "now-playing";
    public static final String MOD_ID_NEOFORGE = "now_playing";
    public static final String MOD_NAME = "Now Playing";
    public static final ModLogger LOG = new ModLogger("Now Playing");
    public static final KeyMapping.Category KEY_CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"now-playing", (String)"group"));
    public static final KeyMapping DISPLAY_KEY = new KeyMapping(Localization.translationKey("key", "group.display"), InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), KEY_CATEGORY);
    public static final KeyMapping NEXT_KEY = new KeyMapping(Localization.translationKey("key", "group.next"), InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), KEY_CATEGORY);
    public static ResourceLocation lastMusic;

    public static void init() {
        Config.getAndSave();
    }

    public static void onEndTick(Minecraft mc) {
        while (DISPLAY_KEY.consumeClick()) {
            NowPlaying.displayLastMusic();
        }
        while (NEXT_KEY.consumeClick()) {
            ((MinecraftAccessor)mc).nowplaying$getMusicManager().stopPlaying();
            ((MinecraftAccessor)mc).nowplaying$getMusicManager().startPlaying(mc.getSituationalMusic());
        }
    }

    public static void onResourceReload() {
        SpriteProvider.onResourceReload();
    }

    public static void displayLastMusic() {
        if (lastMusic != null) {
            NowPlaying.displayMusic(lastMusic);
        } else {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Localization.localized("message", "notFound", new Object[0]).withStyle(ChatFormatting.RED), true);
        }
    }

    public static void displayMusic(ResourceLocation location) {
        Component title = NowPlaying.getTranslatedTitle(location.toString());
        NowPlaying.display(title, () -> SpriteProvider.getMusicSprite(location, title.getString()), Config.options().musicStyle);
    }

    public static void displayDisc(Component text, ResourceLocation location) {
        NowPlaying.display(text, () -> SpriteProvider.getDiscSprite(location), Config.options().jukeboxStyle);
    }

    private static void display(Component name, Supplier<ResourceLocation> spriteSupplier, Config.Options.Style style) {
        Minecraft mc = Minecraft.getInstance();
        MutableComponent message = Component.translatable((String)"record.nowPlaying", (Object[])new Object[]{name});
        switch (style) {
            case Toast: {
                ((ToastManagerAccessor)mc.getToastManager()).nowplaying$getQueued().removeIf(toast -> toast instanceof NowPlayingToast);
                mc.getToastManager().addToast((Toast)new NowPlayingToast(name, spriteSupplier.get(), (long)Config.options().toastTime * 1000L, Config.options().toastScale, Config.options().darkToast));
                if (!Config.options().narrate) break;
                mc.getNarrator().saySystemNow((Component)message);
                break;
            }
            case Hotbar: {
                if (NowPlaying.isHotbarVisible(mc.screen)) {
                    mc.gui.setOverlayMessage((Component)message, true);
                    ((GuiAccessor)mc.gui).nowplaying$setOverlayMessageTime(Config.options().hotbarTime * 20);
                } else if (Config.options().fallbackToast) {
                    ((ToastManagerAccessor)mc.getToastManager()).nowplaying$getQueued().removeIf(toast -> toast instanceof NowPlayingToast);
                    mc.getToastManager().addToast((Toast)new NowPlayingToast(name, spriteSupplier.get(), (long)Config.options().toastTime * 1000L, Config.options().toastScale, Config.options().darkToast));
                }
                if (!Config.options().narrate) break;
                mc.getNarrator().saySystemNow((Component)message);
            }
        }
    }

    public static boolean isHotbarVisible(Screen screen) {
        return screen == null || screen instanceof ChatScreen;
    }

    private static Component getTranslatedTitle(String location) {
        String oldKey;
        String name;
        String[] splitLocation;
        String key = Localization.translationKey(location);
        if (!I18n.exists((String)key) && (splitLocation = location.split("/")).length > 0 && (name = splitLocation[splitLocation.length - 1]) != null && !name.isBlank() && I18n.exists((String)(oldKey = Localization.translationKey("music", name)))) {
            return Component.translatable((String)oldKey);
        }
        return Component.translatable((String)key);
    }
}

