/*
 * Decompiled with CFR 0.152.
 */
package com.github.scotsguy.nowplaying.config;

import com.github.scotsguy.nowplaying.NowPlaying;
import com.github.scotsguy.nowplaying.util.Localization;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path DIR_PATH = Path.of("config", new String[0]);
    private static final String FILE_NAME = "now-playing.json";
    private static final String BACKUP_FILE_NAME = "now-playing.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    public static Options options() {
        return Config.get().options;
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    @NotNull
    public static Config load() {
        Path file = DIR_PATH.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0]) && (config = Config.load(file, GSON)) == null) {
            Config.backup();
            NowPlaying.LOG.warn("Resetting config", new Object[0]);
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                NowPlaying.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            NowPlaying.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            NowPlaying.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        try {
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            NowPlaying.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        public static final boolean onlyKeybindDefault = false;
        public boolean onlyKeybind = false;
        public static final Style musicStyleDefault = Style.Toast;
        public Style musicStyle = musicStyleDefault;
        public static final Style jukeboxStyleDefault = Style.Hotbar;
        public Style jukeboxStyle = jukeboxStyleDefault;
        public static final boolean fallbackToastDefault = true;
        public boolean fallbackToast = true;
        public static final boolean silenceWooshDefault = true;
        public boolean silenceWoosh = true;
        public static final float toastScaleDefault = 1.0f;
        public float toastScale = 1.0f;
        public static final boolean simpleToastDefault = false;
        public boolean simpleToast = false;
        public static final boolean darkToastDefault = false;
        public boolean darkToast = false;
        public static final int toastTimeDefault = 5;
        public int toastTime = 5;
        public static final int hotbarTimeDefault = 3;
        public int hotbarTime = 3;
        public static final boolean narrateDefault = true;
        public boolean narrate = true;

        public static enum Style {
            Toast,
            Hotbar,
            Disabled;


            public static Component name(Enum<Style> style) {
                return switch (style.name()) {
                    case "Toast" -> Localization.localized("option", "style.toast", new Object[0]).withStyle(ChatFormatting.GREEN);
                    case "Hotbar" -> Localization.localized("option", "style.hotbar", new Object[0]).withStyle(ChatFormatting.AQUA);
                    default -> Localization.localized("option", "style.disabled", new Object[0]).withStyle(ChatFormatting.RED);
                };
            }
        }
    }
}

