/*
 * Decompiled with CFR 0.152.
 */
package com.github.scotsguy.nowplaying.gui.toast;

import com.github.scotsguy.nowplaying.config.Config;
import com.github.scotsguy.nowplaying.util.Localization;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class NowPlayingToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE_LIGHT = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private static final int NOW_PLAYING_COLOR_LIGHT = -8388480;
    private static final int TITLE_COLOR_LIGHT = -16777216;
    private static final ResourceLocation BACKGROUND_SPRITE_DARK = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private static final int NOW_PLAYING_COLOR_DARK = -6737255;
    private static final int TITLE_COLOR_DARK = -3026479;
    private final Component description;
    private final ResourceLocation discSprite;
    private final long displayTime;
    private final float scale;
    private final ResourceLocation sprite;
    private final int nowPlayingColor;
    private final int titleColor;
    private Toast.Visibility wantedVisibility;
    private long startTime;
    private static final int TEXT_LEFT_MARGIN = 30;
    private static final int TEXT_RIGHT_MARGIN = 7;

    public NowPlayingToast(Component description, ResourceLocation discSprite, long displayTime, float scale, boolean darkMode) {
        this.description = description;
        this.discSprite = discSprite;
        this.displayTime = displayTime;
        this.scale = scale;
        if (darkMode) {
            this.sprite = BACKGROUND_SPRITE_DARK;
            this.nowPlayingColor = -6737255;
            this.titleColor = -3026479;
        } else {
            this.sprite = BACKGROUND_SPRITE_LIGHT;
            this.nowPlayingColor = -8388480;
            this.titleColor = -16777216;
        }
    }

    @NotNull
    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(@NotNull ToastManager toastManager, long l) {
        this.wantedVisibility = this.startTime >= this.displayTime ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public void render(@NotNull GuiGraphics graphics, @NotNull Font font, long startTime) {
        this.startTime = startTime;
        if (this.scale != 1.0f) {
            graphics.pose().pushMatrix();
            graphics.pose().translate(160.0f * (1.0f - this.scale), 0.0f);
            graphics.pose().scale(this.scale, this.scale);
        }
        Minecraft mc = Minecraft.getInstance();
        int width = this.width();
        int height = this.height();
        List textLines = mc.gui.getFont().split((FormattedText)this.description, width - 30 - 7);
        if (width == 160 && textLines.size() <= 1) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.sprite, 0, 0, width, height);
        } else {
            int bottomHeight = Math.min(4, (height += Math.max(0, textLines.size() - (Config.options().simpleToast ? 2 : 1)) * 12) - 28);
            this.renderBackgroundRow(graphics, width, 0, 0, 28);
            for (int n = 28; n < height - bottomHeight; n += 10) {
                this.renderBackgroundRow(graphics, width, 16, n, Math.min(16, height - n - bottomHeight));
            }
            this.renderBackgroundRow(graphics, width, 32 - bottomHeight, height - bottomHeight, bottomHeight);
        }
        if (Config.options().simpleToast) {
            for (i = 0; i < textLines.size(); ++i) {
                graphics.drawString(mc.font, (FormattedCharSequence)textLines.get(i), 30, textLines.size() == 1 ? 12 : 6 + i * 12, this.titleColor, false);
            }
        } else {
            graphics.drawString(mc.font, (Component)Localization.localized("message", "nowPlaying", new Object[0]), 30, 7, this.nowPlayingColor, false);
            for (i = 0; i < textLines.size(); ++i) {
                graphics.drawString(mc.font, (FormattedCharSequence)textLines.get(i), 30, 18 + i * 12, this.titleColor, false);
            }
        }
        graphics.blit(RenderPipelines.GUI_TEXTURED, this.discSprite, 9, height / 2 - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        if (this.scale != 1.0f) {
            graphics.pose().popMatrix();
        }
    }

    private void renderBackgroundRow(GuiGraphics graphics, int i, int vOffset, int y, int vHeight) {
        int uWidth = vOffset == 0 ? 20 : 5;
        int n = Math.min(60, i - uWidth);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.sprite, 160, 32, 0, vOffset, 0, y, uWidth, vHeight);
        for (int o = uWidth; o < i - n; o += 64) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.sprite, 160, 32, 32, vOffset, o, y, Math.min(64, i - o - n), vHeight);
        }
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.sprite, 160, 32, 160 - n, vOffset, i - n, y, n, vHeight);
    }
}

