/*
 * Decompiled with CFR 0.152.
 */
package com.github.scotsguy.nowplaying.util;

import com.github.scotsguy.nowplaying.NowPlaying;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class SpriteProvider {
    private static final ResourceLocation SPRITES_FILE = ResourceLocation.fromNamespaceAndPath((String)"now-playing", (String)"sprites.json");
    public static final ResourceLocation DISC_SPRITE_DEFAULT = ResourceLocation.parse((String)"minecraft:textures/item/music_disc_cat.png");
    private static final HashMap<String, ResourceLocation> CACHE = new HashMap();
    private static boolean hasAttemptedLoad;

    public static void onResourceReload() {
        CACHE.clear();
        hasAttemptedLoad = false;
    }

    @Nullable
    private static ResourceLocation getCustomSprite(String song) {
        if (CACHE.isEmpty() && !hasAttemptedLoad) {
            SpriteProvider.loadCache();
        }
        return CACHE.get(song);
    }

    private static void loadCache() {
        hasAttemptedLoad = true;
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        try {
            List resourceStack = manager.getResourceStack(SPRITES_FILE);
            for (Resource resource : resourceStack) {
                try (InputStreamReader reader = new InputStreamReader(resource.open());){
                    JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        String spriteStr = ((JsonElement)entry.getValue()).getAsString();
                        ResourceLocation sprite = ResourceLocation.tryParse((String)(spriteStr + ".png"));
                        if (sprite == null) {
                            NowPlaying.LOG.error("Unable to parse sprite location '{}'", spriteStr);
                            continue;
                        }
                        CACHE.put((String)entry.getKey(), sprite);
                    }
                }
            }
        }
        catch (Exception e) {
            NowPlaying.LOG.error("Unable to load sprite cache", e);
        }
    }

    public static ResourceLocation getMusicSprite(ResourceLocation location, String title) {
        String locStr = location.toString();
        ResourceLocation sprite = SpriteProvider.getCustomSprite(locStr);
        if (sprite == null) {
            String namespace = location.getNamespace();
            String path = location.getPath();
            String[] splitPath = path.split("/");
            for (int i = splitPath.length - 1; i > 0 && (sprite = SpriteProvider.getCustomSprite(namespace + ":" + (path = path.substring(0, path.length() - (splitPath[i].length() + 1))))) == null; --i) {
            }
        }
        if (sprite == null) {
            return SpriteProvider.getDefaultSprite(title);
        }
        return sprite;
    }

    public static ResourceLocation getDefaultSprite(String title) {
        if (title.contains("C418")) {
            return ResourceLocation.withDefaultNamespace((String)"textures/item/music_disc_blocks.png");
        }
        if (title.contains("Lena Raine")) {
            return ResourceLocation.withDefaultNamespace((String)"textures/item/music_disc_otherside.png");
        }
        if (title.contains("Aaron Cherof")) {
            return ResourceLocation.withDefaultNamespace((String)"textures/item/music_disc_relic.png");
        }
        if (title.contains("Kumi Tanioka")) {
            return ResourceLocation.withDefaultNamespace((String)"textures/item/music_disc_mall.png");
        }
        if (title.contains("Amos Roddy")) {
            return ResourceLocation.withDefaultNamespace((String)"textures/item/music_disc_tears.png");
        }
        return DISC_SPRITE_DEFAULT;
    }

    public static ResourceLocation getDiscSprite(ResourceLocation location) {
        String discId = location.getPath().replaceAll("\\.", "_");
        return ResourceLocation.parse((String)("textures/item/" + discId + ".png"));
    }
}

