/*
 * Decompiled with CFR 0.152.
 */
package net.marshlaws.customenchantments.network;

import java.util.function.Supplier;
import net.marshlaws.customenchantments.MarshlawsCustomEnchantmentsMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MarshlawsCustomEnchantmentsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"marshlaws_custom_enchantments");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MarshlawsCustomEnchantmentsMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        MarshlawsCustomEnchantmentsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("marshlaws_custom_enchantments", "saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("marshlaws_custom_enchantments", "player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double Vein_meiner_toggle = 0.0;
        public boolean DisableWarningMessage = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("Vein_meiner_toggle", this.Vein_meiner_toggle);
            nbt.putBoolean("DisableWarningMessage", this.DisableWarningMessage);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.Vein_meiner_toggle = nbt.getDouble("Vein_meiner_toggle");
            this.DisableWarningMessage = nbt.getBoolean("DisableWarningMessage");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "marshlaws_custom_enchantments_mapvars";
        public boolean WarpEnabled = true;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.WarpEnabled = nbt.getBoolean("WarpEnabled");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("WarpEnabled", this.WarpEnabled);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "marshlaws_custom_enchantments_worldvars";
        public boolean MagmatorEnabled = true;
        public boolean RegenerationEnabled = true;
        public boolean SlownessEnabled = true;
        public boolean PoisonEnabled = true;
        public boolean LightingEnabled = true;
        public boolean WitherAuraEnabled = true;
        public boolean LifestealEnabled = true;
        public boolean VampirismEnabled = true;
        public boolean NightVisionEnabled = true;
        public boolean HasteEnabled = true;
        public boolean TimberEnabled = true;
        public boolean VeinMiner = true;
        public boolean MagnetEnabled = true;
        public boolean SmelterEnabled = true;
        public boolean HeavyShotEnabled = true;
        public boolean VenomEnabled = true;
        public boolean ExplosiveShot = true;
        public boolean ExplosiveEnabled = true;
        public boolean WeaknessEnabled = true;
        public boolean WisdomEnabled = true;
        public boolean ProsperityEnabled = true;
        public boolean LifebondEnabled = true;
        public boolean CultivatingEnabled = true;
        public boolean StrippedEnabled = true;
        public boolean LeafFortuneEnabled = true;
        public boolean GravelDupper = true;
        public boolean GravelFortuneEnabled = true;
        public boolean SandDupperEnabled = true;
        public boolean GlowstoneDupperEnabled = true;
        public boolean HammerEnabled = true;
        public boolean CorruptionEnabled = true;
        public boolean FlameproffEnabled = true;
        public boolean SpeedEnabled = true;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.MagmatorEnabled = nbt.getBoolean("MagmatorEnabled");
            this.RegenerationEnabled = nbt.getBoolean("RegenerationEnabled");
            this.SlownessEnabled = nbt.getBoolean("SlownessEnabled");
            this.PoisonEnabled = nbt.getBoolean("PoisonEnabled");
            this.LightingEnabled = nbt.getBoolean("LightingEnabled");
            this.WitherAuraEnabled = nbt.getBoolean("WitherAuraEnabled");
            this.LifestealEnabled = nbt.getBoolean("LifestealEnabled");
            this.VampirismEnabled = nbt.getBoolean("VampirismEnabled");
            this.NightVisionEnabled = nbt.getBoolean("NightVisionEnabled");
            this.HasteEnabled = nbt.getBoolean("HasteEnabled");
            this.TimberEnabled = nbt.getBoolean("TimberEnabled");
            this.VeinMiner = nbt.getBoolean("VeinMiner");
            this.MagnetEnabled = nbt.getBoolean("MagnetEnabled");
            this.SmelterEnabled = nbt.getBoolean("SmelterEnabled");
            this.HeavyShotEnabled = nbt.getBoolean("HeavyShotEnabled");
            this.VenomEnabled = nbt.getBoolean("VenomEnabled");
            this.ExplosiveShot = nbt.getBoolean("ExplosiveShot");
            this.ExplosiveEnabled = nbt.getBoolean("ExplosiveEnabled");
            this.WeaknessEnabled = nbt.getBoolean("WeaknessEnabled");
            this.WisdomEnabled = nbt.getBoolean("WisdomEnabled");
            this.ProsperityEnabled = nbt.getBoolean("ProsperityEnabled");
            this.LifebondEnabled = nbt.getBoolean("LifebondEnabled");
            this.CultivatingEnabled = nbt.getBoolean("CultivatingEnabled");
            this.StrippedEnabled = nbt.getBoolean("StrippedEnabled");
            this.LeafFortuneEnabled = nbt.getBoolean("LeafFortuneEnabled");
            this.GravelDupper = nbt.getBoolean("GravelDupper");
            this.GravelFortuneEnabled = nbt.getBoolean("GravelFortuneEnabled");
            this.SandDupperEnabled = nbt.getBoolean("SandDupperEnabled");
            this.GlowstoneDupperEnabled = nbt.getBoolean("GlowstoneDupperEnabled");
            this.HammerEnabled = nbt.getBoolean("HammerEnabled");
            this.CorruptionEnabled = nbt.getBoolean("CorruptionEnabled");
            this.FlameproffEnabled = nbt.getBoolean("FlameproffEnabled");
            this.SpeedEnabled = nbt.getBoolean("SpeedEnabled");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("MagmatorEnabled", this.MagmatorEnabled);
            nbt.putBoolean("RegenerationEnabled", this.RegenerationEnabled);
            nbt.putBoolean("SlownessEnabled", this.SlownessEnabled);
            nbt.putBoolean("PoisonEnabled", this.PoisonEnabled);
            nbt.putBoolean("LightingEnabled", this.LightingEnabled);
            nbt.putBoolean("WitherAuraEnabled", this.WitherAuraEnabled);
            nbt.putBoolean("LifestealEnabled", this.LifestealEnabled);
            nbt.putBoolean("VampirismEnabled", this.VampirismEnabled);
            nbt.putBoolean("NightVisionEnabled", this.NightVisionEnabled);
            nbt.putBoolean("HasteEnabled", this.HasteEnabled);
            nbt.putBoolean("TimberEnabled", this.TimberEnabled);
            nbt.putBoolean("VeinMiner", this.VeinMiner);
            nbt.putBoolean("MagnetEnabled", this.MagnetEnabled);
            nbt.putBoolean("SmelterEnabled", this.SmelterEnabled);
            nbt.putBoolean("HeavyShotEnabled", this.HeavyShotEnabled);
            nbt.putBoolean("VenomEnabled", this.VenomEnabled);
            nbt.putBoolean("ExplosiveShot", this.ExplosiveShot);
            nbt.putBoolean("ExplosiveEnabled", this.ExplosiveEnabled);
            nbt.putBoolean("WeaknessEnabled", this.WeaknessEnabled);
            nbt.putBoolean("WisdomEnabled", this.WisdomEnabled);
            nbt.putBoolean("ProsperityEnabled", this.ProsperityEnabled);
            nbt.putBoolean("LifebondEnabled", this.LifebondEnabled);
            nbt.putBoolean("CultivatingEnabled", this.CultivatingEnabled);
            nbt.putBoolean("StrippedEnabled", this.StrippedEnabled);
            nbt.putBoolean("LeafFortuneEnabled", this.LeafFortuneEnabled);
            nbt.putBoolean("GravelDupper", this.GravelDupper);
            nbt.putBoolean("GravelFortuneEnabled", this.GravelFortuneEnabled);
            nbt.putBoolean("SandDupperEnabled", this.SandDupperEnabled);
            nbt.putBoolean("GlowstoneDupperEnabled", this.GlowstoneDupperEnabled);
            nbt.putBoolean("HammerEnabled", this.HammerEnabled);
            nbt.putBoolean("CorruptionEnabled", this.CorruptionEnabled);
            nbt.putBoolean("FlameproffEnabled", this.FlameproffEnabled);
            nbt.putBoolean("SpeedEnabled", this.SpeedEnabled);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.Vein_meiner_toggle = original.Vein_meiner_toggle;
            clone.DisableWarningMessage = original.DisableWarningMessage;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

