/*
 * Decompiled with CFR 0.152.
 */
package net.marshlaws.customenchantments.network;

import java.util.function.Supplier;
import net.marshlaws.customenchantments.MarshlawsCustomEnchantmentsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MarshlawsCustomEnchantmentsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MarshlawsCustomEnchantmentsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MarshlawsCustomEnchantmentsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Vein_meiner_toggle = message.data.Vein_meiner_toggle;
                    variables.DisableWarningMessage = message.data.DisableWarningMessage;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Vein_meiner_toggle = 0.0;
        public boolean DisableWarningMessage = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MarshlawsCustomEnchantmentsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Vein_meiner_toggle", this.Vein_meiner_toggle);
            nbt.m_128379_("DisableWarningMessage", this.DisableWarningMessage);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Vein_meiner_toggle = nbt.m_128459_("Vein_meiner_toggle");
            this.DisableWarningMessage = nbt.m_128471_("DisableWarningMessage");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("marshlaws_custom_enchantments", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "marshlaws_custom_enchantments_mapvars";
        public boolean WarpEnabled = true;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.WarpEnabled = nbt.m_128471_("WarpEnabled");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("WarpEnabled", this.WarpEnabled);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MarshlawsCustomEnchantmentsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "marshlaws_custom_enchantments_worldvars";
        public boolean MagmatorEnabled = true;
        public boolean RegenerationEnabled = true;
        public boolean SlownessEnabled = true;
        public boolean PoisonEnabled = true;
        public boolean LightingEnabled = true;
        public boolean WitherAuraEnabled = true;
        public boolean LifestealEnabled = true;
        public boolean VampirismEnabled = true;
        public boolean NightVisionEnabled = true;
        public boolean HasteEnabled = true;
        public boolean TimberEnabled = true;
        public boolean VeinMiner = true;
        public boolean MagnetEnabled = true;
        public boolean SmelterEnabled = true;
        public boolean HeavyShotEnabled = true;
        public boolean VenomEnabled = true;
        public boolean ExplosiveShot = true;
        public boolean ExplosiveEnabled = true;
        public boolean WeaknessEnabled = true;
        public boolean WisdomEnabled = true;
        public boolean ProsperityEnabled = true;
        public boolean LifebondEnabled = true;
        public boolean CultivatingEnabled = true;
        public boolean StrippedEnabled = true;
        public boolean LeafFortuneEnabled = true;
        public boolean GravelDupper = true;
        public boolean GravelFortuneEnabled = true;
        public boolean SandDupperEnabled = true;
        public boolean GlowstoneDupperEnabled = true;
        public boolean HammerEnabled = true;
        public boolean CorruptionEnabled = true;
        public boolean FlameproffEnabled = true;
        public boolean SpeedEnabled = true;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.MagmatorEnabled = nbt.m_128471_("MagmatorEnabled");
            this.RegenerationEnabled = nbt.m_128471_("RegenerationEnabled");
            this.SlownessEnabled = nbt.m_128471_("SlownessEnabled");
            this.PoisonEnabled = nbt.m_128471_("PoisonEnabled");
            this.LightingEnabled = nbt.m_128471_("LightingEnabled");
            this.WitherAuraEnabled = nbt.m_128471_("WitherAuraEnabled");
            this.LifestealEnabled = nbt.m_128471_("LifestealEnabled");
            this.VampirismEnabled = nbt.m_128471_("VampirismEnabled");
            this.NightVisionEnabled = nbt.m_128471_("NightVisionEnabled");
            this.HasteEnabled = nbt.m_128471_("HasteEnabled");
            this.TimberEnabled = nbt.m_128471_("TimberEnabled");
            this.VeinMiner = nbt.m_128471_("VeinMiner");
            this.MagnetEnabled = nbt.m_128471_("MagnetEnabled");
            this.SmelterEnabled = nbt.m_128471_("SmelterEnabled");
            this.HeavyShotEnabled = nbt.m_128471_("HeavyShotEnabled");
            this.VenomEnabled = nbt.m_128471_("VenomEnabled");
            this.ExplosiveShot = nbt.m_128471_("ExplosiveShot");
            this.ExplosiveEnabled = nbt.m_128471_("ExplosiveEnabled");
            this.WeaknessEnabled = nbt.m_128471_("WeaknessEnabled");
            this.WisdomEnabled = nbt.m_128471_("WisdomEnabled");
            this.ProsperityEnabled = nbt.m_128471_("ProsperityEnabled");
            this.LifebondEnabled = nbt.m_128471_("LifebondEnabled");
            this.CultivatingEnabled = nbt.m_128471_("CultivatingEnabled");
            this.StrippedEnabled = nbt.m_128471_("StrippedEnabled");
            this.LeafFortuneEnabled = nbt.m_128471_("LeafFortuneEnabled");
            this.GravelDupper = nbt.m_128471_("GravelDupper");
            this.GravelFortuneEnabled = nbt.m_128471_("GravelFortuneEnabled");
            this.SandDupperEnabled = nbt.m_128471_("SandDupperEnabled");
            this.GlowstoneDupperEnabled = nbt.m_128471_("GlowstoneDupperEnabled");
            this.HammerEnabled = nbt.m_128471_("HammerEnabled");
            this.CorruptionEnabled = nbt.m_128471_("CorruptionEnabled");
            this.FlameproffEnabled = nbt.m_128471_("FlameproffEnabled");
            this.SpeedEnabled = nbt.m_128471_("SpeedEnabled");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("MagmatorEnabled", this.MagmatorEnabled);
            nbt.m_128379_("RegenerationEnabled", this.RegenerationEnabled);
            nbt.m_128379_("SlownessEnabled", this.SlownessEnabled);
            nbt.m_128379_("PoisonEnabled", this.PoisonEnabled);
            nbt.m_128379_("LightingEnabled", this.LightingEnabled);
            nbt.m_128379_("WitherAuraEnabled", this.WitherAuraEnabled);
            nbt.m_128379_("LifestealEnabled", this.LifestealEnabled);
            nbt.m_128379_("VampirismEnabled", this.VampirismEnabled);
            nbt.m_128379_("NightVisionEnabled", this.NightVisionEnabled);
            nbt.m_128379_("HasteEnabled", this.HasteEnabled);
            nbt.m_128379_("TimberEnabled", this.TimberEnabled);
            nbt.m_128379_("VeinMiner", this.VeinMiner);
            nbt.m_128379_("MagnetEnabled", this.MagnetEnabled);
            nbt.m_128379_("SmelterEnabled", this.SmelterEnabled);
            nbt.m_128379_("HeavyShotEnabled", this.HeavyShotEnabled);
            nbt.m_128379_("VenomEnabled", this.VenomEnabled);
            nbt.m_128379_("ExplosiveShot", this.ExplosiveShot);
            nbt.m_128379_("ExplosiveEnabled", this.ExplosiveEnabled);
            nbt.m_128379_("WeaknessEnabled", this.WeaknessEnabled);
            nbt.m_128379_("WisdomEnabled", this.WisdomEnabled);
            nbt.m_128379_("ProsperityEnabled", this.ProsperityEnabled);
            nbt.m_128379_("LifebondEnabled", this.LifebondEnabled);
            nbt.m_128379_("CultivatingEnabled", this.CultivatingEnabled);
            nbt.m_128379_("StrippedEnabled", this.StrippedEnabled);
            nbt.m_128379_("LeafFortuneEnabled", this.LeafFortuneEnabled);
            nbt.m_128379_("GravelDupper", this.GravelDupper);
            nbt.m_128379_("GravelFortuneEnabled", this.GravelFortuneEnabled);
            nbt.m_128379_("SandDupperEnabled", this.SandDupperEnabled);
            nbt.m_128379_("GlowstoneDupperEnabled", this.GlowstoneDupperEnabled);
            nbt.m_128379_("HammerEnabled", this.HammerEnabled);
            nbt.m_128379_("CorruptionEnabled", this.CorruptionEnabled);
            nbt.m_128379_("FlameproffEnabled", this.FlameproffEnabled);
            nbt.m_128379_("SpeedEnabled", this.SpeedEnabled);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MarshlawsCustomEnchantmentsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Vein_meiner_toggle = original.Vein_meiner_toggle;
            clone.DisableWarningMessage = original.DisableWarningMessage;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MarshlawsCustomEnchantmentsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MarshlawsCustomEnchantmentsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MarshlawsCustomEnchantmentsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

