/*
 * Decompiled with CFR 0.152.
 */
package net.marshlaws.customenchantments.network;

import java.util.function.Supplier;
import net.marshlaws.customenchantments.MarshlawsCustomEnchantmentsMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class MarshlawsCustomEnchantmentsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"marshlaws_custom_enchantments");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MarshlawsCustomEnchantmentsMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        MarshlawsCustomEnchantmentsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"marshlaws_custom_enchantments", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            SavedData patt0$temp = message.data;
            if (patt0$temp instanceof MapVariables) {
                MapVariables mapVariables = (MapVariables)patt0$temp;
                buffer.writeNbt((Tag)mapVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            } else {
                SavedData patt1$temp = message.data;
                if (patt1$temp instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)patt1$temp;
                    buffer.writeNbt((Tag)worldVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
                }
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(((MapVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(((WorldVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"marshlaws_custom_enchantments", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        public double Vein_meiner_toggle = 0.0;
        public boolean DisableWarningMessage = false;

        public void serialize(ValueOutput output) {
            output.putDouble("Vein_meiner_toggle", this.Vein_meiner_toggle);
            output.putBoolean("DisableWarningMessage", this.DisableWarningMessage);
        }

        public void deserialize(ValueInput input) {
            this.Vein_meiner_toggle = input.getDoubleOr("Vein_meiner_toggle", 0.0);
            this.DisableWarningMessage = input.getBooleanOr("DisableWarningMessage", false);
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final SavedDataType<MapVariables> TYPE = new SavedDataType("marshlaws_custom_enchantments_mapvars", ctx -> new MapVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            MapVariables instance = new MapVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        public boolean WarpEnabled = true;
        static MapVariables clientSide = new MapVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.WarpEnabled = nbt.getBooleanOr("WarpEnabled", false);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("WarpEnabled", this.WarpEnabled);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAccessor.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final SavedDataType<WorldVariables> TYPE = new SavedDataType("marshlaws_custom_enchantments_worldvars", ctx -> new WorldVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            WorldVariables instance = new WorldVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        public boolean MagmatorEnabled = true;
        public boolean RegenerationEnabled = true;
        public boolean SlownessEnabled = true;
        public boolean PoisonEnabled = true;
        public boolean LightingEnabled = true;
        public boolean WitherAuraEnabled = true;
        public boolean LifestealEnabled = true;
        public boolean VampirismEnabled = true;
        public boolean NightVisionEnabled = true;
        public boolean HasteEnabled = true;
        public boolean TimberEnabled = true;
        public boolean VeinMiner = true;
        public boolean MagnetEnabled = true;
        public boolean SmelterEnabled = true;
        public boolean HeavyShotEnabled = true;
        public boolean VenomEnabled = true;
        public boolean ExplosiveShot = true;
        public boolean ExplosiveEnabled = true;
        public boolean WeaknessEnabled = true;
        public boolean WisdomEnabled = true;
        public boolean ProsperityEnabled = true;
        public boolean LifebondEnabled = true;
        public boolean CultivatingEnabled = true;
        public boolean StrippedEnabled = true;
        public boolean LeafFortuneEnabled = true;
        public boolean GravelDupper = true;
        public boolean GravelFortuneEnabled = true;
        public boolean SandDupperEnabled = true;
        public boolean GlowstoneDupperEnabled = true;
        public boolean HammerEnabled = true;
        public boolean CorruptionEnabled = true;
        public boolean FlameproffEnabled = true;
        public boolean SpeedEnabled = true;
        static WorldVariables clientSide = new WorldVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.MagmatorEnabled = nbt.getBooleanOr("MagmatorEnabled", false);
            this.RegenerationEnabled = nbt.getBooleanOr("RegenerationEnabled", false);
            this.SlownessEnabled = nbt.getBooleanOr("SlownessEnabled", false);
            this.PoisonEnabled = nbt.getBooleanOr("PoisonEnabled", false);
            this.LightingEnabled = nbt.getBooleanOr("LightingEnabled", false);
            this.WitherAuraEnabled = nbt.getBooleanOr("WitherAuraEnabled", false);
            this.LifestealEnabled = nbt.getBooleanOr("LifestealEnabled", false);
            this.VampirismEnabled = nbt.getBooleanOr("VampirismEnabled", false);
            this.NightVisionEnabled = nbt.getBooleanOr("NightVisionEnabled", false);
            this.HasteEnabled = nbt.getBooleanOr("HasteEnabled", false);
            this.TimberEnabled = nbt.getBooleanOr("TimberEnabled", false);
            this.VeinMiner = nbt.getBooleanOr("VeinMiner", false);
            this.MagnetEnabled = nbt.getBooleanOr("MagnetEnabled", false);
            this.SmelterEnabled = nbt.getBooleanOr("SmelterEnabled", false);
            this.HeavyShotEnabled = nbt.getBooleanOr("HeavyShotEnabled", false);
            this.VenomEnabled = nbt.getBooleanOr("VenomEnabled", false);
            this.ExplosiveShot = nbt.getBooleanOr("ExplosiveShot", false);
            this.ExplosiveEnabled = nbt.getBooleanOr("ExplosiveEnabled", false);
            this.WeaknessEnabled = nbt.getBooleanOr("WeaknessEnabled", false);
            this.WisdomEnabled = nbt.getBooleanOr("WisdomEnabled", false);
            this.ProsperityEnabled = nbt.getBooleanOr("ProsperityEnabled", false);
            this.LifebondEnabled = nbt.getBooleanOr("LifebondEnabled", false);
            this.CultivatingEnabled = nbt.getBooleanOr("CultivatingEnabled", false);
            this.StrippedEnabled = nbt.getBooleanOr("StrippedEnabled", false);
            this.LeafFortuneEnabled = nbt.getBooleanOr("LeafFortuneEnabled", false);
            this.GravelDupper = nbt.getBooleanOr("GravelDupper", false);
            this.GravelFortuneEnabled = nbt.getBooleanOr("GravelFortuneEnabled", false);
            this.SandDupperEnabled = nbt.getBooleanOr("SandDupperEnabled", false);
            this.GlowstoneDupperEnabled = nbt.getBooleanOr("GlowstoneDupperEnabled", false);
            this.HammerEnabled = nbt.getBooleanOr("HammerEnabled", false);
            this.CorruptionEnabled = nbt.getBooleanOr("CorruptionEnabled", false);
            this.FlameproffEnabled = nbt.getBooleanOr("FlameproffEnabled", false);
            this.SpeedEnabled = nbt.getBooleanOr("SpeedEnabled", false);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("MagmatorEnabled", this.MagmatorEnabled);
            nbt.putBoolean("RegenerationEnabled", this.RegenerationEnabled);
            nbt.putBoolean("SlownessEnabled", this.SlownessEnabled);
            nbt.putBoolean("PoisonEnabled", this.PoisonEnabled);
            nbt.putBoolean("LightingEnabled", this.LightingEnabled);
            nbt.putBoolean("WitherAuraEnabled", this.WitherAuraEnabled);
            nbt.putBoolean("LifestealEnabled", this.LifestealEnabled);
            nbt.putBoolean("VampirismEnabled", this.VampirismEnabled);
            nbt.putBoolean("NightVisionEnabled", this.NightVisionEnabled);
            nbt.putBoolean("HasteEnabled", this.HasteEnabled);
            nbt.putBoolean("TimberEnabled", this.TimberEnabled);
            nbt.putBoolean("VeinMiner", this.VeinMiner);
            nbt.putBoolean("MagnetEnabled", this.MagnetEnabled);
            nbt.putBoolean("SmelterEnabled", this.SmelterEnabled);
            nbt.putBoolean("HeavyShotEnabled", this.HeavyShotEnabled);
            nbt.putBoolean("VenomEnabled", this.VenomEnabled);
            nbt.putBoolean("ExplosiveShot", this.ExplosiveShot);
            nbt.putBoolean("ExplosiveEnabled", this.ExplosiveEnabled);
            nbt.putBoolean("WeaknessEnabled", this.WeaknessEnabled);
            nbt.putBoolean("WisdomEnabled", this.WisdomEnabled);
            nbt.putBoolean("ProsperityEnabled", this.ProsperityEnabled);
            nbt.putBoolean("LifebondEnabled", this.LifebondEnabled);
            nbt.putBoolean("CultivatingEnabled", this.CultivatingEnabled);
            nbt.putBoolean("StrippedEnabled", this.StrippedEnabled);
            nbt.putBoolean("LeafFortuneEnabled", this.LeafFortuneEnabled);
            nbt.putBoolean("GravelDupper", this.GravelDupper);
            nbt.putBoolean("GravelFortuneEnabled", this.GravelFortuneEnabled);
            nbt.putBoolean("SandDupperEnabled", this.SandDupperEnabled);
            nbt.putBoolean("GlowstoneDupperEnabled", this.GlowstoneDupperEnabled);
            nbt.putBoolean("HammerEnabled", this.HammerEnabled);
            nbt.putBoolean("CorruptionEnabled", this.CorruptionEnabled);
            nbt.putBoolean("FlameproffEnabled", this.FlameproffEnabled);
            nbt.putBoolean("SpeedEnabled", this.SpeedEnabled);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.Vein_meiner_toggle = original.Vein_meiner_toggle;
            clone.DisableWarningMessage = original.DisableWarningMessage;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

