/*
 * Decompiled with CFR 0.152.
 */
package com.lostboydev.toomanytask;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.lostboydev.toomanytask.TodoItem;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTodoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientTodoManager.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ClientTodoManager instance;
    private Map<String, List<TodoItem>> todosByServer = new HashMap<String, List<TodoItem>>();
    private String currentServerId = null;

    private ClientTodoManager() {
        this.loadTodos();
    }

    public static ClientTodoManager getInstance() {
        if (instance == null) {
            instance = new ClientTodoManager();
        }
        return instance;
    }

    private String getCurrentServerId() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return null;
        }
        if (mc.hasSingleplayerServer()) {
            return "singleplayer_" + mc.getSingleplayerServer().getWorldData().getLevelName();
        }
        ServerData serverData = mc.getCurrentServer();
        if (serverData != null) {
            return "multiplayer_" + serverData.ip;
        }
        ClientLevel level = mc.level;
        return "unknown_" + level.dimension().location().toString();
    }

    public void updateServerContext() {
        String newServerId = this.getCurrentServerId();
        if (!Objects.equals(this.currentServerId, newServerId)) {
            this.currentServerId = newServerId;
            if (this.currentServerId != null && !this.todosByServer.containsKey(this.currentServerId)) {
                ArrayList<TodoItem> welcomeTodos = new ArrayList<TodoItem>();
                welcomeTodos.add(new TodoItem("Welcome to TooManyTasks!"));
                welcomeTodos.add(new TodoItem("Press R to open the todo list"));
                welcomeTodos.add(new TodoItem("This list is saved per server/world"));
                this.todosByServer.put(this.currentServerId, welcomeTodos);
                this.saveTodos();
            }
        }
    }

    public List<TodoItem> getTodos() {
        this.updateServerContext();
        if (this.currentServerId == null) {
            return new ArrayList<TodoItem>();
        }
        return this.todosByServer.getOrDefault(this.currentServerId, new ArrayList());
    }

    public void addTodo(String text) {
        this.updateServerContext();
        if (this.currentServerId == null) {
            return;
        }
        List todos = this.todosByServer.computeIfAbsent(this.currentServerId, k -> new ArrayList());
        todos.add(new TodoItem(text));
        this.saveTodos();
    }

    public void removeTodo(UUID id) {
        this.updateServerContext();
        if (this.currentServerId == null) {
            return;
        }
        List<TodoItem> todos = this.todosByServer.get(this.currentServerId);
        if (todos != null) {
            todos.removeIf(todo -> todo.getId().equals(id));
            this.saveTodos();
        }
    }

    public void toggleTodo(UUID id) {
        this.updateServerContext();
        if (this.currentServerId == null) {
            return;
        }
        List<TodoItem> todos = this.todosByServer.get(this.currentServerId);
        if (todos != null) {
            for (TodoItem todo : todos) {
                if (!todo.getId().equals(id)) continue;
                todo.setCompleted(!todo.isCompleted());
                this.saveTodos();
                break;
            }
        }
    }

    public void updateTodo(UUID id, String newText) {
        this.updateServerContext();
        if (this.currentServerId == null) {
            return;
        }
        List<TodoItem> todos = this.todosByServer.get(this.currentServerId);
        if (todos != null) {
            for (TodoItem todo : todos) {
                if (!todo.getId().equals(id)) continue;
                todo.setText(newText);
                this.saveTodos();
                break;
            }
        }
    }

    public void clearCompleted() {
        this.updateServerContext();
        if (this.currentServerId == null) {
            return;
        }
        List<TodoItem> todos = this.todosByServer.get(this.currentServerId);
        if (todos != null) {
            todos.removeIf(TodoItem::isCompleted);
            this.saveTodos();
        }
    }

    public int getCompletedCount() {
        return (int)this.getTodos().stream().filter(TodoItem::isCompleted).count();
    }

    public int getTotalCount() {
        return this.getTodos().size();
    }

    private File getTodosFile() {
        File configDir = new File(Minecraft.getInstance().gameDirectory, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        return new File(configDir, "toomanytasks_todos.json");
    }

    private void saveTodos() {
        try (FileWriter writer = new FileWriter(this.getTodosFile());){
            GSON.toJson(this.todosByServer, (Appendable)writer);
            LOGGER.debug("Saved todos for {} servers", (Object)this.todosByServer.size());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save todos", (Throwable)e);
        }
    }

    private void loadTodos() {
        File todosFile = this.getTodosFile();
        if (!todosFile.exists()) {
            LOGGER.debug("No existing todos file found");
            return;
        }
        try (FileReader reader = new FileReader(todosFile);){
            Type type = new TypeToken<Map<String, List<TodoItem>>>(this){}.getType();
            Map loaded = (Map)GSON.fromJson((Reader)reader, type);
            if (loaded != null) {
                this.todosByServer = loaded;
                LOGGER.debug("Loaded todos for {} servers", (Object)this.todosByServer.size());
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load todos", (Throwable)e);
        }
    }

    public String getCurrentServerName() {
        this.updateServerContext();
        if (this.currentServerId == null) {
            return "Unknown";
        }
        if (this.currentServerId.startsWith("singleplayer_")) {
            return this.currentServerId.substring("singleplayer_".length());
        }
        if (this.currentServerId.startsWith("multiplayer_")) {
            return this.currentServerId.substring("multiplayer_".length());
        }
        return this.currentServerId;
    }
}

