/*
 * Decompiled with CFR 0.152.
 */
package com.lostboydev.toomanytask;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class TodoItem {
    private final UUID id;
    private String text;
    private boolean completed;
    private long createdAt;
    private long completedAt;

    public TodoItem(String text) {
        this.id = UUID.randomUUID();
        this.text = text;
        this.completed = false;
        this.createdAt = System.currentTimeMillis();
        this.completedAt = 0L;
    }

    public TodoItem(UUID id, String text, boolean completed, long createdAt, long completedAt) {
        this.id = id;
        this.text = text;
        this.completed = completed;
        this.createdAt = createdAt;
        this.completedAt = completedAt;
    }

    public UUID getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
        this.completedAt = completed ? System.currentTimeMillis() : 0L;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getCompletedAt() {
        return this.completedAt;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("id", this.id);
        tag.putString("text", this.text);
        tag.putBoolean("completed", this.completed);
        tag.putLong("createdAt", this.createdAt);
        tag.putLong("completedAt", this.completedAt);
        return tag;
    }

    public static TodoItem fromNBT(CompoundTag tag) {
        return new TodoItem(tag.getUUID("id"), tag.getString("text"), tag.getBoolean("completed"), tag.getLong("createdAt"), tag.getLong("completedAt"));
    }
}

