/*
 * Decompiled with CFR 0.152.
 */
package com.lostboydev.toomanytask;

import com.lostboydev.toomanytask.TodoItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class TodoManager
extends SavedData {
    private final List<TodoItem> todos = new ArrayList<TodoItem>();
    private static final String DATA_NAME = "toomanytasks_todos";

    public TodoManager() {
        this.addTodo("Welcome to TooManyTasks!");
        this.addTodo("Press R to open the todo list");
        this.addTodo("Click to mark items as complete");
    }

    public List<TodoItem> getTodos() {
        return new ArrayList<TodoItem>(this.todos);
    }

    public void addTodo(String text) {
        this.todos.add(new TodoItem(text));
        this.setDirty();
    }

    public void removeTodo(UUID id) {
        this.todos.removeIf(todo -> todo.getId().equals(id));
        this.setDirty();
    }

    public void toggleTodo(UUID id) {
        for (TodoItem todo : this.todos) {
            if (!todo.getId().equals(id)) continue;
            todo.setCompleted(!todo.isCompleted());
            this.setDirty();
            break;
        }
    }

    public void updateTodo(UUID id, String newText) {
        for (TodoItem todo : this.todos) {
            if (!todo.getId().equals(id)) continue;
            todo.setText(newText);
            this.setDirty();
            break;
        }
    }

    public void clearCompleted() {
        this.todos.removeIf(TodoItem::isCompleted);
        this.setDirty();
    }

    public int getCompletedCount() {
        return (int)this.todos.stream().filter(TodoItem::isCompleted).count();
    }

    public int getTotalCount() {
        return this.todos.size();
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag todoList = new ListTag();
        for (TodoItem todo : this.todos) {
            todoList.add((Object)todo.toNBT());
        }
        tag.put("todos", (Tag)todoList);
        return tag;
    }

    public static TodoManager load(CompoundTag tag, HolderLookup.Provider registries) {
        TodoManager manager = new TodoManager();
        manager.todos.clear();
        ListTag todoList = tag.getList("todos", 10);
        for (int i = 0; i < todoList.size(); ++i) {
            CompoundTag todoTag = todoList.getCompound(i);
            manager.todos.add(TodoItem.fromNBT(todoTag));
        }
        return manager;
    }

    public static TodoManager get(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        return (TodoManager)storage.computeIfAbsent(new SavedData.Factory(TodoManager::new, TodoManager::load, null), DATA_NAME);
    }
}

