/*
 * Decompiled with CFR 0.152.
 */
package com.lostboydev.toomanytask;

import com.lostboydev.toomanytask.ClientTodoManager;
import com.lostboydev.toomanytask.TodoItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TodoScreen
extends Screen {
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 200;
    private static final int ITEM_HEIGHT = 20;
    private static final int SCROLLBAR_WIDTH = 6;
    private int guiLeft;
    private int guiTop;
    private EditBox addTodoBox;
    private Button addButton;
    private Button clearCompletedButton;
    private List<TodoItem> todos = new ArrayList<TodoItem>();
    private int scrollOffset = 0;
    private UUID editingTodoId = null;
    private EditBox editingBox;
    private int maxVisibleItems;

    public TodoScreen() {
        super((Component)Component.translatable((String)"gui.toomanytasks.todo_title"));
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - 256) / 2;
        this.guiTop = (this.height - 200) / 2;
        this.maxVisibleItems = 5;
        this.addTodoBox = new EditBox(this.font, this.guiLeft + 10, this.guiTop + 25, 176, 20, (Component)Component.empty());
        this.addTodoBox.setMaxLength(100);
        this.addTodoBox.setValue("");
        this.addButton = Button.builder((Component)Component.translatable((String)"gui.toomanytasks.add"), button -> {
            String text = this.addTodoBox.getValue().trim();
            if (!text.isEmpty()) {
                this.addTodo(text);
                this.addTodoBox.setValue("");
            }
        }).bounds(this.guiLeft + 256 - 65, this.guiTop + 25, 55, 20).build();
        this.clearCompletedButton = Button.builder((Component)Component.translatable((String)"gui.toomanytasks.clear_completed"), button -> this.clearCompleted()).bounds(this.guiLeft + 10, this.guiTop + 200 - 30, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.addTodoBox);
        this.addRenderableWidget((GuiEventListener)this.addButton);
        this.addRenderableWidget((GuiEventListener)this.clearCompletedButton);
        this.loadTodos();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(this.guiLeft, this.guiTop, this.guiLeft + 256, this.guiTop + 200, -2013265920);
        guiGraphics.fill(this.guiLeft + 1, this.guiTop + 1, this.guiLeft + 256 - 1, this.guiTop + 200 - 1, -14540254);
        guiGraphics.drawCenteredString(this.font, this.title, this.guiLeft + 128, this.guiTop + 5, 0xFFFFFF);
        this.renderTodoItems(guiGraphics, mouseX, mouseY);
        if (this.todos.size() > this.maxVisibleItems) {
            this.renderScrollbar(guiGraphics);
        }
        String stats = String.format("%d/%d completed", this.getCompletedCount(), this.todos.size());
        guiGraphics.drawString(this.font, stats, this.guiLeft + 256 - 80, this.guiTop + 200 - 20, 0x888888);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderTodoItems(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int startY = this.guiTop + 55;
        int endIndex = Math.min(this.scrollOffset + this.maxVisibleItems, this.todos.size());
        for (int i = this.scrollOffset; i < endIndex; ++i) {
            String prefix;
            TodoItem todo = this.todos.get(i);
            int y = startY + (i - this.scrollOffset) * 20;
            if (this.editingTodoId != null && this.editingTodoId.equals(todo.getId())) {
                if (this.editingBox == null) {
                    this.editingBox = new EditBox(this.font, this.guiLeft + 30, y, 186, 16, (Component)Component.empty());
                    this.editingBox.setValue(todo.getText());
                    this.editingBox.setMaxLength(100);
                    this.editingBox.setFocused(true);
                }
                this.editingBox.render(guiGraphics, mouseX, mouseY, 0.0f);
                continue;
            }
            Object displayText = todo.getText();
            int availableWidth = 201;
            String string = prefix = todo.isCompleted() ? "\u2611 " : "\u2610 ";
            while (this.font.width(prefix + (String)displayText) > availableWidth && ((String)displayText).length() > 3) {
                displayText = ((String)displayText).substring(0, ((String)displayText).length() - 1);
            }
            if (!((String)displayText).equals(todo.getText()) && ((String)displayText).length() > 3) {
                displayText = ((String)displayText).substring(0, ((String)displayText).length() - 3) + "...";
            }
            int textColor = todo.isCompleted() ? 0x888888 : 0xFFFFFF;
            guiGraphics.drawString(this.font, prefix + (String)displayText, this.guiLeft + 10, y + 2, textColor);
            guiGraphics.drawString(this.font, "\u00d7", this.guiLeft + 256 - 25, y + 2, 0xFF0000);
        }
    }

    private void renderScrollbar(GuiGraphics guiGraphics) {
        int scrollbarX = this.guiLeft + 256 - 6 - 8;
        int scrollbarY = this.guiTop + 55;
        int scrollbarHeight = this.maxVisibleItems * 20;
        int maxScrollbarY = this.guiTop + 200 - 30;
        if (scrollbarY + scrollbarHeight > maxScrollbarY) {
            scrollbarHeight = maxScrollbarY - scrollbarY;
        }
        guiGraphics.fill(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -2013265920);
        int maxScroll = Math.max(1, this.todos.size() - this.maxVisibleItems);
        int thumbHeight = Math.max(10, this.maxVisibleItems * scrollbarHeight / this.todos.size());
        int thumbY = scrollbarY + this.scrollOffset * (scrollbarHeight - thumbHeight) / maxScroll;
        guiGraphics.fill(scrollbarX, thumbY, scrollbarX + 6, thumbY + thumbHeight, -1996488705);
        guiGraphics.fill(scrollbarX, scrollbarY, scrollbarX + 1, scrollbarY + scrollbarHeight, -1996488705);
        guiGraphics.fill(scrollbarX + 6 - 1, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -1996488705);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.todos.size() > this.maxVisibleItems) {
            int scrollbarX = this.guiLeft + 256 - 6 - 8;
            int scrollbarY = this.guiTop + 55;
            int scrollbarHeight = this.maxVisibleItems * 20;
            int maxScrollbarY = this.guiTop + 200 - 30;
            if (scrollbarY + scrollbarHeight > maxScrollbarY) {
                scrollbarHeight = maxScrollbarY - scrollbarY;
            }
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                double clickRatio = (mouseY - (double)scrollbarY) / (double)scrollbarHeight;
                int maxScroll = this.todos.size() - this.maxVisibleItems;
                this.scrollOffset = (int)(clickRatio * (double)maxScroll);
                this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset));
                return true;
            }
        }
        if (button == 0) {
            int startY = this.guiTop + 55;
            int endIndex = Math.min(this.scrollOffset + this.maxVisibleItems, this.todos.size());
            for (int i = this.scrollOffset; i < endIndex; ++i) {
                TodoItem todo = this.todos.get(i);
                int y = startY + (i - this.scrollOffset) * 20;
                if (!(mouseY >= (double)y) || !(mouseY <= (double)(y + 20))) continue;
                if (mouseX >= (double)(this.guiLeft + 10) && mouseX <= (double)(this.guiLeft + 256 - 35)) {
                    if (this.editingTodoId == null) {
                        this.toggleTodo(todo.getId());
                    }
                } else if (mouseX >= (double)(this.guiLeft + 256 - 30) && mouseX <= (double)(this.guiLeft + 256 - 15)) {
                    this.removeTodo(todo.getId());
                }
                return true;
            }
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.editingBox != null && this.editingBox.isFocused()) {
            if (keyCode == 256) {
                this.editingTodoId = null;
                this.editingBox = null;
                return true;
            }
            if (keyCode == 257) {
                if (this.editingTodoId != null) {
                    this.updateTodo(this.editingTodoId, this.editingBox.getValue().trim());
                    this.editingTodoId = null;
                    this.editingBox = null;
                }
                return true;
            }
            return this.editingBox.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.todos.size() > this.maxVisibleItems) {
            int maxScroll = this.todos.size() - this.maxVisibleItems;
            this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)deltaY));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void loadTodos() {
        this.todos.clear();
        this.todos.addAll(ClientTodoManager.getInstance().getTodos());
    }

    private void addTodo(String text) {
        ClientTodoManager.getInstance().addTodo(text);
        this.refreshTodos();
    }

    private void removeTodo(UUID id) {
        ClientTodoManager.getInstance().removeTodo(id);
        this.refreshTodos();
    }

    private void toggleTodo(UUID id) {
        ClientTodoManager.getInstance().toggleTodo(id);
        this.refreshTodos();
    }

    private void updateTodo(UUID id, String newText) {
        ClientTodoManager.getInstance().updateTodo(id, newText);
        this.refreshTodos();
    }

    private void clearCompleted() {
        ClientTodoManager.getInstance().clearCompleted();
        this.refreshTodos();
    }

    private int getCompletedCount() {
        return ClientTodoManager.getInstance().getCompletedCount();
    }

    public void refreshTodos() {
        this.todos.clear();
        this.todos.addAll(ClientTodoManager.getInstance().getTodos());
        int maxScroll = Math.max(0, this.todos.size() - this.maxVisibleItems);
        this.scrollOffset = Math.min(this.scrollOffset, maxScroll);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

