/*
 * Decompiled with CFR 0.152.
 */
package com.lostboydev.toomanytask.network;

import com.lostboydev.toomanytask.TodoManager;
import com.lostboydev.toomanytask.network.ClientTodoCache;
import com.lostboydev.toomanytask.network.TodoActionPacket;
import com.lostboydev.toomanytask.network.TodoSyncPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandler {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(TodoActionPacket.TYPE, TodoActionPacket.STREAM_CODEC, NetworkHandler::handleTodoAction);
        registrar.playToClient(TodoSyncPacket.TYPE, TodoSyncPacket.STREAM_CODEC, NetworkHandler::handleTodoSync);
    }

    public static void handleTodoAction(TodoActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp;
            if (context.flow().isServerbound() && (patt0$temp = context.player()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ServerLevel level = (ServerLevel)serverPlayer.level();
                TodoManager manager = TodoManager.get(level);
                switch (packet.action()) {
                    case ADD: {
                        if (packet.text() == null) break;
                        manager.addTodo(packet.text());
                        break;
                    }
                    case REMOVE: {
                        if (packet.todoId() == null) break;
                        manager.removeTodo(packet.todoId());
                        break;
                    }
                    case TOGGLE: {
                        if (packet.todoId() == null) break;
                        manager.toggleTodo(packet.todoId());
                        break;
                    }
                    case UPDATE: {
                        if (packet.todoId() == null || packet.text() == null) break;
                        manager.updateTodo(packet.todoId(), packet.text());
                        break;
                    }
                    case CLEAR_COMPLETED: {
                        manager.clearCompleted();
                        break;
                    }
                    case REQUEST_SYNC: {
                        TodoSyncPacket syncPacket = new TodoSyncPacket(manager.getTodos());
                        context.reply((CustomPacketPayload)syncPacket);
                        return;
                    }
                }
                TodoSyncPacket syncPacket = new TodoSyncPacket(manager.getTodos());
                context.reply((CustomPacketPayload)syncPacket);
            }
        });
    }

    public static void handleTodoSync(TodoSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.flow().isClientbound()) {
                ClientTodoCache.updateTodos(packet.todos());
            }
        });
    }
}

