/*
 * Decompiled with CFR 0.152.
 */
package com.lostboydev.toomanytask.network;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record TodoActionPacket(Action action, UUID todoId, String text) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TodoActionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"toomanytasks", (String)"todo_action"));
    public static final StreamCodec<FriendlyByteBuf, TodoActionPacket> STREAM_CODEC = StreamCodec.of(TodoActionPacket::write, TodoActionPacket::read);

    public static void write(FriendlyByteBuf buf, TodoActionPacket packet) {
        buf.writeEnum((Enum)packet.action);
        if (packet.todoId != null) {
            buf.writeBoolean(true);
            buf.writeUUID(packet.todoId);
        } else {
            buf.writeBoolean(false);
        }
        if (packet.text != null) {
            buf.writeBoolean(true);
            buf.writeUtf(packet.text);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static TodoActionPacket read(FriendlyByteBuf buf) {
        Action action = (Action)buf.readEnum(Action.class);
        UUID todoId = buf.readBoolean() ? buf.readUUID() : null;
        String text = buf.readBoolean() ? buf.readUtf() : null;
        return new TodoActionPacket(action, todoId, text);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static TodoActionPacket add(String text) {
        return new TodoActionPacket(Action.ADD, null, text);
    }

    public static TodoActionPacket remove(UUID todoId) {
        return new TodoActionPacket(Action.REMOVE, todoId, null);
    }

    public static TodoActionPacket toggle(UUID todoId) {
        return new TodoActionPacket(Action.TOGGLE, todoId, null);
    }

    public static TodoActionPacket update(UUID todoId, String text) {
        return new TodoActionPacket(Action.UPDATE, todoId, text);
    }

    public static TodoActionPacket clearCompleted() {
        return new TodoActionPacket(Action.CLEAR_COMPLETED, null, null);
    }

    public static TodoActionPacket requestSync() {
        return new TodoActionPacket(Action.REQUEST_SYNC, null, null);
    }

    public static enum Action {
        ADD,
        REMOVE,
        TOGGLE,
        UPDATE,
        CLEAR_COMPLETED,
        REQUEST_SYNC;

    }
}

