/*
 * Decompiled with CFR 0.152.
 */
package com.lostboydev.toomanytask.network;

import com.lostboydev.toomanytask.TodoItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record TodoSyncPacket(List<TodoItem> todos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TodoSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"toomanytasks", (String)"todo_sync"));
    public static final StreamCodec<FriendlyByteBuf, TodoSyncPacket> STREAM_CODEC = StreamCodec.of(TodoSyncPacket::write, TodoSyncPacket::read);

    public static void write(FriendlyByteBuf buf, TodoSyncPacket packet) {
        buf.writeInt(packet.todos.size());
        for (TodoItem todo : packet.todos) {
            buf.writeUUID(todo.getId());
            buf.writeUtf(todo.getText());
            buf.writeBoolean(todo.isCompleted());
            buf.writeLong(todo.getCreatedAt());
            buf.writeLong(todo.getCompletedAt());
        }
    }

    public static TodoSyncPacket read(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<TodoItem> todos = new ArrayList<TodoItem>();
        for (int i = 0; i < size; ++i) {
            UUID id = buf.readUUID();
            String text = buf.readUtf();
            boolean completed = buf.readBoolean();
            long createdAt = buf.readLong();
            long completedAt = buf.readLong();
            todos.add(new TodoItem(id, text, completed, createdAt, completedAt));
        }
        return new TodoSyncPacket(todos);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

